/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ProfilerConfigFactory.java,v 1.6 2006/03/09 20:30:40 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:40 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.support.oldconfig.OldJavaConfigMBean;

import com.sun.appserv.management.config.ProfilerConfigKeys;

import com.sun.appserv.management.util.misc.GSetUtil;


public final class ProfilerConfigFactory  extends ConfigFactory
{
	private final OldJavaConfigMBean	mOldJavaConfigMBean;
	
		public
	ProfilerConfigFactory(
		final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
		
		mOldJavaConfigMBean =
		    getOldConfigProxies().getOldJavaConfigMBean( getConfigName() );
	}
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
    		ProfilerConfigKeys.CLASSPATH_KEY,
    		ProfilerConfigKeys.NATIVE_LIBRARY_PATH_KEY,
    		ProfilerConfigKeys.ENABLED_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}

		public ObjectName
	create( final String name, final Map<String,String> optional )
	{
		final Map<String,String> params = initParams( name, null, optional );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
	}
	
		public void
	internalRemove( final ObjectName objectName )
	{
		mOldJavaConfigMBean.removeProfiler();
	}

		protected ObjectName
	createOldChildConfig( final AttributeList attrs )
	{
		return mOldJavaConfigMBean.createProfiler( attrs );
	}
}

