/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/StandaloneServerConfigFactory.java,v 1.6 2006/03/09 20:30:41 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:41 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;
import java.util.Properties;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.support.oldconfig.OldServersMBean;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.config.ServerConfigKeys;


public class StandaloneServerConfigFactory extends ConfigFactory
{
	private final OldServersMBean	mOldServersMBean;
	
		public
	StandaloneServerConfigFactory( final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
		
		mOldServersMBean	= callbacks.getOldConfigProxies().getOldServersMBean();
	}
        
    private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet( 
		ServerConfigKeys.HTTP_LISTENER_1_PORT_KEY,
		ServerConfigKeys.HTTP_LISTENER_2_PORT_KEY,
		ServerConfigKeys.ORB_LISTENER_1_PORT_KEY,
		ServerConfigKeys.ADMIN_LISTENER_PORT_KEY,
		ServerConfigKeys.SSL_PORT_KEY,
		ServerConfigKeys.SSL_MUTUALAUTH_PORT_KEY,
		ServerConfigKeys.JMX_SYSTEM_CONNECTOR_PORT_KEY,
		ServerConfigKeys.JMS_PROVIDER_PORT_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
		public ObjectName
	create(
		final String name,
		final String nodeAgentName,
		final String configName,
		final Map<String,String> optional)
	{
	    debug( "create:\n" + (optional == null ? "null" : MapUtil.toString( optional )) );
	    
		final Map<String,String> all = initParams(name, null, optional );
		final Properties props = new Properties();
		final AttributeList attrList = new AttributeList();
		translateParams(all, attrList, props);

		//create the new server with the new config that was copied
		final ObjectName oldObjectName =
			mOldServersMBean.createServerInstance(nodeAgentName, name, configName, null, props);

		return syncNewAMXMBeanWithOld(oldObjectName);
	}
        
		protected void
	removeByName(final String name)
	{
		mOldServersMBean.deleteServerInstance(name);
	}
}




