/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/StorePropertiesConfigFactory.java,v 1.5 2006/03/09 20:30:42 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:42 $
 */


package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.support.oldconfig.OldSessionManagerMBean;

import com.sun.appserv.management.config.StorePropertiesConfigKeys;

import com.sun.appserv.management.util.misc.GSetUtil;


public final class StorePropertiesConfigFactory extends ConfigFactory
{
	private final OldSessionManagerMBean	mOldSessionManager;
	
		public 
	StorePropertiesConfigFactory(final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
		
		mOldSessionManager	=
		    getOldConfigProxies().getOldSessionManagerMBean( getConfigName() );
	}
	
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet( StorePropertiesConfigKeys.DIRECTORY_KEY,
		StorePropertiesConfigKeys.REAP_INTERVAL_IN_SECONDS_KEY);
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	



		protected void 
	internalRemove( final ObjectName objectName )
	{
		mOldSessionManager.removeStoreProperties();
	}

		protected ObjectName
	createOldChildConfig( final AttributeList attrs )
	{
		return mOldSessionManager.createStoreProperties( attrs );
	}

}

