/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/j2ee/J2EEDomainImpl.java,v 1.5 2005/12/25 03:40:05 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2005/12/25 03:40:05 $
 */
package com.sun.enterprise.management.j2ee;

import java.util.Map;
import java.util.Set;

import javax.management.ObjectName;

import com.sun.appserv.management.j2ee.J2EETypes;
import com.sun.appserv.management.j2ee.J2EEDomain;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.appserv.management.j2ee.J2EECluster;
import com.sun.appserv.management.base.XTypes;


import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

/**
 */
public final class J2EEDomainImpl extends J2EEManagedObjectImplBase
{
		public
	J2EEDomainImpl()
	{
	}
	
		public boolean
	isConfigProvider()
	{
		return( true );
	}
	
	private static final Set<String> NOT_SUPERFLUOUS =
	    GSetUtil.newUnmodifiableStringSet( "getServerObjectNameMap", "getClusterObjectNameMap" );
	    
	    protected final Set<String>
	getNotSuperfluousMethods()
	{
	    return GSetUtil.newSet( super.getNotSuperfluousMethods(), NOT_SUPERFLUOUS );
	}
	
	    public Map<String,ObjectName>
	getServerObjectNameMap()
	{
	    return Util.toObjectNames( getSelfProxy().getJ2EEServerMap() );
	}
	
	    public Map<String,ObjectName>
	getClusterObjectNameMap()
	{
	    return Util.toObjectNames( getSelfProxy().getJ2EEClusterMap() );
	}

	    private J2EEDomain
	getSelfProxy()
	{
	    return (J2EEDomain)getSelf();
	}
	
	/**
		JSR 77 impl
		@return String representation of the ObjectName
	 */
		public String[]
	getservers()
	{
	    final Map<String,J2EEServer> servers = getSelfProxy().getJ2EEServerMap();
	    final Map<String,ObjectName> objectNames = Util.toObjectNames( servers );
		return( CollectionUtil.toStringArray( objectNames.values() ) );
	}
	
		public ObjectName
	getConfigPeerObjectName()
	{
		return Util.getObjectName( getDomainRoot().getDomainConfig() );
	}

	/**
		JSR 77 impl
		@return String representation of the ObjectName
	 */
		public String[]
	getclusters()
	{
	    final Map<String,J2EECluster> clusters = getSelfProxy().getJ2EEClusterMap();
	    final Map<String,ObjectName> objectNames = Util.toObjectNames( clusters );
		return( CollectionUtil.toStringArray( objectNames.values() ) );
	}
}


