/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/j2ee/J2EEModuleImplBase.java,v 1.4 2005/12/25 03:40:06 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:40:06 $
 */
 
package com.sun.enterprise.management.j2ee;

import java.util.Set;

import javax.management.ObjectName;
import javax.management.AttributeNotFoundException;

import com.sun.appserv.management.j2ee.J2EEModule;
import com.sun.appserv.management.j2ee.J2EEServer;


import com.sun.appserv.management.base.Util;


import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.appserv.management.j2ee.J2EETypes;

import com.sun.enterprise.management.support.Delegate;

/**
 */
public class J2EEModuleImplBase extends J2EEDeployedObjectImplBase
{
		public
	J2EEModuleImplBase(
		final Delegate delegate )
	{
		super( delegate );
	}
	
	private static final Set<String> NOT_SUPERFLUOUS =
	    GSetUtil.newUnmodifiableStringSet(
	        "getJVMObjectName"
            );
        protected Set<String>
	getNotSuperfluousMethods()
	{
	    return NOT_SUPERFLUOUS;
	}
	
	
		protected boolean
	isStandalone()
	{
		// caution--could be called when ObjectName is not yet set
		return getObjectName() != null &&
			getKeyProperty( J2EETypes.J2EE_APPLICATION ).equals( NULL_NAME );
	}
	
		public boolean
	isConfigProvider()
	{
		return( super.isConfigProvider() && getObjectName() != null && isStandalone() );
	}
	
		public String[]
	getjavaVMs()
	{
		return( getJ2EEServer().getjavaVMs() );
	}
	
		public ObjectName
	getJVMObjectName()
	{
		return Util.getObjectName( getJ2EEServer().getJVM() );
	}

	/** jsr77 StateManageable impl. */

		public boolean
	isstateManageable()
	{
		return isStandAlone();
	}

		private boolean
	isStandAlone()
	{
		return !getContainer().getJ2EEType().equals( J2EETypes.J2EE_APPLICATION );
	}
}
