/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.j2ee;
 
import java.util.Map;
import java.io.Serializable;

import javax.management.ObjectName;

import com.sun.appserv.management.monitor.WebServiceEndpointMonitor;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats;

import com.sun.enterprise.management.support.Delegate;

/**
 */
public final class WebServiceEndpointImpl extends J2EEManagedObjectImplBase
{
		public
	WebServiceEndpointImpl( final Delegate delegate )
	{
		super( delegate );
	}
	
		public WebServiceEndpointAggregateStats
	getStats()
	{
		return( (WebServiceEndpointAggregateStats)getStatsGeneric() );
	}

    		public boolean
	isConfigProvider()
	{	
		return( false );
	}

    public Map<String,Serializable>[] getMessagesInHistory() {
        Map<String,Serializable>[] result = null;
        try {
            result= TypeCast.asArray( getDelegate().invoke( 
                "getMessagesInHistory", null, null) );
        } catch (Exception e) {
        	final Throwable rootCause = ExceptionUtil.getRootCause( e );
			getMBeanLogger().warning( rootCause.toString() + "\n" +
				ExceptionUtil.getStackTrace( rootCause ) );
        }
        return result;
    }

    public ObjectName getImplementationPeerObjectName() {
        unimplementedOperation("getImplementationPeer");
          return null;
    }

    public String getImplementationType() {
        String result = null;
        try {
            if ( getDelegate().supportsOperation( "getImplementationType", null, null ) )
            {
                result= (String)getDelegate().invoke( "getImplementationType", null, null);
            }
        } catch (Exception e) {
              getMBeanLogger().warning( ExceptionUtil.toString( e ) );
        }
        
        return result;
    }

    protected String getMonitoringPeerJ2EEType() {
		return( XTypes.WEBSERVICE_ENDPOINT_MONITOR );
	}

}
