/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import javax.management.ObjectName;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;

import com.sun.appserv.management.base.Util;
import com.sun.enterprise.management.support.AMXServerLogger;
import com.sun.enterprise.management.support.AMXMBeanRootLogger;

import com.sun.enterprise.admin.server.core.AdminService;

/**
	Utilities to help boot up AMX.
 */
public final class BootUtil
{
	private final String	mAppserverDomainName;

	private final String	mAMX_JMXDomain;
	
	private static BootUtil	INSTANCE	= null;
	
	private boolean         mAMXReady;
	
	private final boolean   mOfflineAMX;
	 
		private
	BootUtil(
	    final String    appserverDomainName,
	    final boolean   offline )
	{
		AMXServerLogger.getInstance();
		AMXMBeanRootLogger.getInstance();
		
		mAppserverDomainName	= appserverDomainName;
		mAMX_JMXDomain		    = appserverDomainName;
		
		mAMXReady   = false;
		
		mOfflineAMX = offline;
	}
    
    /**
        Return the name of the server in which this code is running.
     */
        public String
    getServerName()
    {
        return  AdminService.getAdminService().getAdminContext().getServerName();
    }
    
		public static synchronized void
	init( final boolean offline )
	{
		INSTANCE	= new BootUtil( "amx", offline );
	}

        public boolean
    getOffline()
    {
        return mOfflineAMX;
    }

		public static synchronized BootUtil
	getInstance()
	{
	    if ( INSTANCE == null )
	    {   
	        throw new IllegalArgumentException( "must call init() first" );
	    }

		return( INSTANCE );
	}
	
		public boolean
	getAMXReady()
	{
	    return mAMXReady;
	}
	
		public void
	setAMXReady( final boolean  ready)
	{
	    if ( mAMXReady && ! ready )
	    {
	        throw new IllegalArgumentException();
	    }
	    
	    mAMXReady   = ready;
	}

		private ObjectName
	getObjectName( String props )
	{
		final String	domain	= getAMXSupportJMXDomain();
		
		return( Util.newObjectName( domain, props ) );
	}
	
	    public String
	getAMXSupportJMXDomain()
	{
	    return getAMXJMXDomainName() + "-support";
	}
	
		public String
	getAppserverDomainName()
	{
		return( mAppserverDomainName );
	}
	
		public String
	getAMXJMXDomainName()
	{
		return( mAMX_JMXDomain );
	}
}








