/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import java.io.Serializable;

import java.util.Set;
import java.util.Map;
import java.util.Collections;

import javax.management.MBeanInfo;

/**
	Dummy implementation used when coverage is not being gathered.
	@see AMXDebugStuff
 */
public final class CoverageInfoDummy implements Serializable, CoverageInfo
{
    public static final long    serialVersionUID    = 0xABCDEF;
    
        public
    CoverageInfoDummy()
    {
    }

    static private final Set<String>           EMPTY_SET   = Collections.emptySet();
    static private final Map<String,Integer>    EMPTY_MAP  = Collections.emptyMap();
    
    public void         clear() {}
    
    public MBeanInfo    getMBeanInfo()  { return null; }
    public void         setMBeanInfo(MBeanInfo info)  { }
    public void         merge( final CoverageInfo info )  {}
    
    public Set<String>  getReadableAttributes() { return EMPTY_SET; }
    public Set<String>  getWriteableAttributes() { return EMPTY_SET; }
    public Set<String>  getOperations() { return EMPTY_SET; }
    
    public Set<String>  getAttributesRead()  { return EMPTY_SET; }
    public Set<String>  getAttributesNotRead()  { return EMPTY_SET; }
    
    public Set<String>  getAttributesWritten()  { return EMPTY_SET; }
    public Set<String>  getAttributesNotWritten()  { return EMPTY_SET; }
    
    public Set<String>  getOperationsInvoked()  { return EMPTY_SET; }
    public Set<String>  getOperationsNotInvoked()  { return EMPTY_SET; }
    
    public Map<String,Integer>  getAttributeGetFailures()  { return EMPTY_MAP; }
    public Map<String,Integer>  getAttributeSetFailures()  { return EMPTY_MAP; }
    
    public Map<String,Integer>  getUnknownAttributes()  { return EMPTY_MAP; }
    public Map<String,Integer>  getUnknownOperations()  { return EMPTY_MAP; }
    
    public Map<String,Integer>  getInvocationFailures()  { return EMPTY_MAP; }
    
    public String       toString( final boolean   verbose ) { return "CoverageInfoDummy"; }
    
    
    public  int         getAttributeReadCoverage()  { return 0; }
    public  int         getAttributeWriteCoverage()  { return 0; }
    public  int         getOperationCoverage()  { return 0; }
    public  boolean     getFullCoverage()  { return false; }
    
    public void         ignoreUnknownAttribute( final String name )  {}
    public void         unknownAttribute( final String name ) {}
    public void         attributeWasRead( final String name )  {}
    public void         attributesWereRead( final String[] name )  {}
    public void         attributeWasWritten( final String name )  {}
    public void         attributeGetFailure( final String name ) {}
    public void         attributeSetFailure( final String name ) {}

    public void         unknownOperation(final String name, final String[]  sig) {}
    public void         operationWasInvoked(final String name, final String[]  sig) {}
    public void         markAsInvoked(final String fullname ){}
    
    public void         operationFailed(final String name, final String[] sig) {}
}








































