/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/support/DownloadInfo.java,v 1.4 2005/12/25 03:40:42 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:40:42 $
 */
package com.sun.enterprise.management.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;


public final class DownloadInfo extends UpDownInfo
{
	private FileInputStream	mInputStream;
	
	private long			mReadSoFar;
	private final long		mTotalSize;
	private final boolean	mDeleteWhenDone;
	
		public
	DownloadInfo(
		final Object	id,
		final File		theFile,
		final boolean	deleteWhenDone )
		throws IOException
	{
		super( id, theFile );
		
		mTotalSize		= theFile.length();
		if ( theFile.length() == 0 )
		{
			throw new IllegalArgumentException( theFile.toString() );
		}
		
		mReadSoFar		= 0;
		mDeleteWhenDone	= deleteWhenDone;
		
		if ( mDeleteWhenDone )
		{
			theFile.deleteOnExit();
		}
		
		mInputStream	= new FileInputStream( theFile );
		
		assert( ! isDone() );
	}
	
	
		public final long
	getLength()
	{
		return( mTotalSize );
	}
	
		private final long
	getRemaining()
	{
		return( mTotalSize - mReadSoFar );
	}
	
		public boolean
	isDone()
	{
		return( mReadSoFar == mTotalSize );
	}
	
	
	/**
		@return true if done, false otherwise
	 */
		public synchronized byte[]
	read( final int requestSize )
		throws IOException
	{
		if ( isDone() )
		{
			throw new IllegalArgumentException( "operation has been completed" );
		}
		
		final long	remaining	= getRemaining();
		
		byte[]		bytes	= null;
		if ( remaining != 0 )
		{
			final long	actual		= remaining < requestSize ? remaining : requestSize;
			
			bytes	= new byte[ (int)actual ];
			final int	numRead	= mInputStream.read( bytes );
			if ( numRead != bytes.length )
			{
				throw new IOException();
			}
			
			mReadSoFar	+= numRead;
			
			if ( isDone() )
			{
				cleanup();
			}
			
			accessed();
		}
		
		return( bytes );
	}
	
		public synchronized void
	cleanup()
		throws IOException
	{
		if ( mInputStream != null )
		{
			mInputStream.close();
			mInputStream	= null;
		}
		
		if ( mDeleteWhenDone )
		{
			getFile().delete();
		}
	}
}

