/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/support/Attic/LoadBalancerClusterRefRegistrationListener.java,v 1.5 2006/03/09 20:30:47 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:47 $
 */

package com.sun.enterprise.management.support;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.io.IOException;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.JMException;
import javax.management.InstanceNotFoundException;

import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.enterprise.management.support.ObjectNames;

import com.sun.appserv.management.monitor.LoadBalancerMonitor;  
import com.sun.appserv.management.monitor.LoadBalancerClusterMonitor;
import com.sun.appserv.management.monitor.LoadBalancerServerMonitor;
import com.sun.appserv.management.monitor.LoadBalancerApplicationMonitor;
import com.sun.appserv.management.monitor.LoadBalancerContextRootMonitor;

import static com.sun.appserv.management.base.XTypes.CLUSTER_REF_CONFIG;
import com.sun.appserv.management.config.DeployedItemRefConfig;
import com.sun.appserv.management.config.ClusterRefConfig;
import com.sun.appserv.management.config.ClusterConfig;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.ClusteredServerConfig;      
import com.sun.appserv.management.config.LBConfig;

/**
 * A class that triggers forming LB monitoring tree whenever a new <cluster-ref>
 * gets added to a <lb-config> element. The registration logic 
 * 1. locates <load-balancer> elements referring to the <lb-config> under which  
 *    the present <cluster-ref> got added
 * 2. fetches root container monitors, LoadBalancerMonitor, for each 
 *    <load-balancer> found in step 1
 * 3. registers a LoadBalancerClusterMonitor under each of this root 
 *    LoadBalancerMonitor found in step 2
 * 4. fetches the <server> elements (via <server-ref> elements) for this 
 *    <cluster-ref> element
 * 5. registers a LoadBalancerServerMonitor under each of this 
 *    LoadBalancerClusterMonitor found in step 3
 * 6. fetches the <application> elements (via <application-ref> elements) for  
 *    each <server> element found in step 4.
 * 7. registers a LoadBalancerApplicationMonitor under each of the
 *    LoadBalancerServerMonitor found in step 5
 * 6. fetches the context roots for each <application> element found in step 6.
 * 8. registers a LoadBalancerContextRootMonitor under each of the
 *    LoadBalancerApplicationMonitor found in step 7
 *
 * @see LoadBalancerServerRefRegistrationListener
 * @see LoadBalancerApplicationRefRegistrationListener
 * @see LoadBalancerRegistrationListener
 */
public class LoadBalancerClusterRefRegistrationListener 
    extends LBBaseMBeanRegistrationListener {
    
    public LoadBalancerClusterRefRegistrationListener(MBeanServer mBeanServer)
        throws InstanceNotFoundException, IOException {
        super(mBeanServer);
    }

    protected void mbeanRegistered(final ObjectName objectName) {
        try {
            if (CLUSTER_REF_CONFIG.equals(Util.getJ2EEType(objectName))) {
                ClusterRefConfig clusterRefConfig = 
                    ProxyFactory.getInstance(getConn()).getProxy(objectName, ClusterRefConfig.class);
                String clusterName = clusterRefConfig.getRef();                    
                Container container = clusterRefConfig.getContainer();

                if (container instanceof LBConfig) {
                    List<LoadBalancerMonitor> lbmList = 
                        fetchLBMonitoringRoots((LBConfig)container);
                    
                    for (LoadBalancerMonitor lbm : lbmList) {
                        registerLoadBalancerClusterMonitorTree(lbm, clusterName);
                    }
                    
                }
            }
	} catch (Exception ex) {
            logWarning(
                "LoadBalancerClusterRefRegistrationListener mbeanRegistered " +
                    "failed. Exception = ", ex);	
	}
    }
}