/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;

import java.util.List;
import java.util.Set;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;


import javax.management.ObjectName;
import javax.management.MBeanRegistration;
import javax.management.NotificationListener;

import com.sun.appserv.management.util.misc.ExceptionUtil;
	
final class LoaderRegThread extends Thread
{
	private boolean			mQuit;
	private List<ObjectName>			mRegistrationQueue;
	private List<ObjectName>			mUnregistrationQueue;
	private final Logger	mLogger;
	private final LoaderRegHandler	mRegHandler;
	
		public
	LoaderRegThread(
		final LoaderRegHandler	regHandler,
		final Logger	logger )
	{
		mRegHandler	= regHandler;
		mLogger	= logger;
		mQuit	= false;

		mRegistrationQueue		= Collections.synchronizedList( new ArrayList<ObjectName>() );
		mUnregistrationQueue	= Collections.synchronizedList( new ArrayList<ObjectName>() );
	}
	
		private final Logger
	getLogger( )
	{
		return( mLogger );
	}
	
		private final void
	trace( final Object o )
	{
		if ( mLogger != null )
		{
			mLogger.finer( o.toString() );
		}
	}

		public void
	quit()
	{
		mQuit	= true;
		synchronized( this )
		{
			this.notify();
		}
	}

		public void
	enqueue(
		final boolean		register,
		final List			candidates )
	{
		final Iterator	iter	= candidates.iterator();
		while ( iter.hasNext() )
		{
			enqueue( register, (ObjectName)iter.next() );
		}
	}
	
		public void
	enqueue(
		final boolean		register,
		final ObjectName	theObject )
	{
		final List<ObjectName> theQueue;
		
		if ( register )
		{
			theQueue	= mRegistrationQueue;
		}
		else
		{
			theQueue	= mUnregistrationQueue;
		}
		
		theQueue.add( theObject );
		
		synchronized( this )
		{
			this.notify();
		}
	}

		private ObjectName
	dequeue( final List<ObjectName> theQueue )
	{
		ObjectName	theObject	= null;
		
		synchronized( theQueue )
		{
			if ( theQueue.size() != 0 )
			{
				theObject	= (ObjectName)theQueue.remove( 0 );
			}
		}
		return( theObject );
	}


		public void
	run()
	{
		// never wake up unless interrupted
		final int	INTERVAL	=  1024 * 1024 * 1024;
		
		mQuit	= false;
		
		trace( "Loader.RegThread.run(): start" );
		while ( ! mQuit )
		{
			try
			{
				trace( "Loader.RegThread.run(): waiting" );
				synchronized( this )
				{
					wait();
				}
			}
			catch( InterruptedException e )
			{
				trace( "Loader.RegThread.run(): interrupted from wait" );
			}
			
			if ( mQuit )
			{
				break;
			}
			
			processRegistrations();
			processUnregistrations();
		}
	}


		private void
	mySleep( final long millis )
	{
		try
		{
			Thread.sleep( millis );
		}
		catch( InterruptedException e )
		{
		}
	}
	
		public void
	waitEmpty()
	{
		int	queueSize	= 0;
		
		while ( (queueSize = mRegistrationQueue.size() ) != 0 )
		{
			mySleep( 100 );
		}
		trace( "RegThread.waitEmpty: queue is empty" );
	}
	
		public int
	getRegistrationQueueSize()
	{
		return( mRegistrationQueue.size() );
	}

	/** WORKAROUND_FOR_BUG_SRIDATTA_FOUND (should not be public)*/
		public synchronized void
	processRegistration( final ObjectName objectName )
	{
		try
		{
			mRegHandler.handleMBeanRegistered( objectName );
			getLogger().finer( "LoaderRegThread.processRegistration: processed mbean: " + objectName );
		}
		catch( Throwable t )
		{
			getLogger().warning( "LoaderRegThread.processRegistration: " +
				"registration of MBean failed for: " + 
				objectName + " = " + t.toString() + ", " + t.getMessage() + "\n" +
				ExceptionUtil.getStackTrace( t ) );
		}
	}
	
	/** WORKAROUND_FOR_BUG_SRIDATTA_FOUND (should not be public)*/
		public synchronized void
	processUnregistration( final ObjectName objectName )
	{
		try
		{
			mRegHandler.handleMBeanUnregistered( objectName );
		}
		catch( Throwable t )
		{
			getLogger().warning( "LoaderRegThread.processUnregistration: " +
				"unregistration of MBean failed for: " + 
				objectName + " = " + t.toString() );
		}
	}
	
		private void
	processRegistrations()
	{
		ObjectName	objectName	= null;
		 
		int	numDone	= 0;
		while ( (objectName = dequeue( mRegistrationQueue )) != null )
		{
			processRegistration( objectName );
			++numDone;
		}
		getLogger().fine( "LoaderRegThread: processed mbeans: " + numDone );
	}
	
		private void
	processUnregistrations()
	{
		ObjectName	objectName	= null;
		 
		while ( (objectName = dequeue( mUnregistrationQueue )) != null )
		{
			processUnregistration( objectName );
		}
	}
}




