/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management;


import java.util.Map;
import java.util.HashMap;
import java.util.Collections;


/**
 */
public final class Capabilities 
{
    private final HashMap<String,Object>    mItems;
    
    public static final String  OFFLINE_KEY = "Offline";
    
	    public
	Capabilities()
	{
	    mItems  = new HashMap<String,Object>();
	}
	
	    public
	Capabilities( final Object[] pairs )
	{
	    this();
	    for( int i = 0; i < pairs.length; i +=2  )
	    {
	        add( (String)pairs[ i ], pairs[ i + 1] );
	    }
	}
	
	    public Map<String,Object>
	getAll()
	{
	    return Collections.unmodifiableMap( mItems );
	}
	
	
	public boolean getOfflineCapable()
	{
	    return "true".equals( "" + mItems.get( OFFLINE_KEY ) );
	}
	
	public void setOfflineCapable( boolean value )
	{
	    add( OFFLINE_KEY, "" + value );
	}
	
	    public void
	add( final String key, final Object value )
	{
	    assert( ! mItems.containsKey( key ) );
	    mItems.put( key, value );
	}
};
















