/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management;

import java.util.Set;

import javax.management.ObjectName;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ConnectionSource;


/**
    Observes various things as tests are run.
 */
public final class Observer
{
    private static Observer   INSTANCE    = null;
    
    private final RegistrationListener  mListener;
    
    private final DomainRoot    mDomainRoot;
    
		private
	Observer( final DomainRoot  domainRoot )
	{
	    mDomainRoot = domainRoot;
	    
	    final ConnectionSource connSource   =
	        Util.getExtra(domainRoot).getConnectionSource();
	    
        try
        {
            mListener   = new RegistrationListener(
                connSource.getExistingMBeanServerConnection() );
        }
        catch ( Exception e )
        {
            throw new RuntimeException( e );
        }
	}
	
	    public static synchronized Observer
	create( final DomainRoot  domainRoot )
	{
	    if ( INSTANCE == null )
	    {
	        INSTANCE    = new Observer( domainRoot );
	    }
	    else
	    {
	        throw new IllegalArgumentException();
	    }
	    return INSTANCE;
	}
	
	    public static Observer
	getInstance()
	{
	    return INSTANCE;
	}
	
	    public RegistrationListener
	getRegistrationListener()
	{
	    return mListener;
	}
	
	    public Set<ObjectName>
	getCurrentlyRegisteredAMX()
	{
	    return mListener.getCurrentlyRegistered();
	}
	
	    public void
	notifsLost()
	{
	    mListener.notifsLost();
	}
	
}














