/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.base;

import java.util.Set;
import java.util.HashSet;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;

import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.base.AMXAttributes;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class BulkAccessTest extends AMXTestBase
{
		public
	BulkAccessTest( )
	{
	}
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( true );
	}
	

		public void
	testGetBulkAccess()
	{
		assert( getBulkAccess() != null );
	}
	
		public void
	testBulkGetMBeanAttributeInfos()
		throws Exception
	{
		final long	start	= now();
		
		final ObjectName[]	objectNames	= getTestUtil().getAllAMXArray();
		
		// get everything in bulk....
		final Object[]	infos	=
			getBulkAccess().bulkGetMBeanAttributeInfo( objectNames );
		
		// now verify that getting it singly yields the same result.
		final MBeanServerConnection	conn	= getConnection();
		for( int i = 0; i < infos.length; ++i )
		{
			
			final MBeanAttributeInfo[]	bulkAttributes	= (MBeanAttributeInfo[])infos[ i ];
			
			final MBeanInfo	info	= conn.getMBeanInfo( objectNames[ i ] );
			assert( ArrayUtil.arraysEqual( info.getAttributes(), bulkAttributes ) );
		}
		printElapsed( "testBulkGetMBeanAttributeInfos", objectNames.length, start );
	}
	
		public void
	testBulkGetMBeanOperationInfos()
		throws Exception
	{
		final long	start	= now();
		
		final ObjectName[]	objectNames	= getTestUtil().getAllAMXArray();
		
		final Object[]	infos	=
			getBulkAccess().bulkGetMBeanOperationInfo( objectNames );
		
		// now verify that getting it singly yields the same result.
		final MBeanServerConnection	conn	= getConnection();
		for( int i = 0; i < infos.length; ++i )
		{
			
			final MBeanOperationInfo[]	bulkOperations	= (MBeanOperationInfo[])infos[ i ];
			
			final MBeanInfo	info	= conn.getMBeanInfo( objectNames[ i ] );
			assert( ArrayUtil.arraysEqual( info.getOperations(), bulkOperations ) );			
		}
		printElapsed( "testBulkGetMBeanOperationInfos", objectNames.length, start );
	}
	
		public void
	testAttributeNamesAttributeCorrect()
		throws Exception
	{
		final long	start	= now();
		
		final ObjectName[]	objectNames	= getTestUtil().getAllAMXArray();
		
		final Object[]	nameArrays	=
			getBulkAccess().bulkGetAttributeNames( objectNames );
		
		final Set<ObjectName>   failed  = new HashSet<ObjectName>();
		// now verify that getting it singly yields the same result.
		for( int i = 0; i < nameArrays.length; ++i )
		{
			final String[]	bulkNames	= (String[])nameArrays[ i ];
			
			// verify that the AttributeNames Attribute contains all the names
			final String[]	attrNames	= (String[])
				getConnection().getAttribute( objectNames[ i ], "AttributeNames" );
			
			final Set<String>	bulkSet		= GSetUtil.newStringSet( bulkNames );
			final Set<String>	attrsSet	= GSetUtil.newStringSet( attrNames );
			if (! bulkSet.equals( attrsSet ) )
			{
			    warning( "testAttributeNamesAttributeCorrect failed for " + objectNames[ i ] );
			    failed.add( objectNames[ i ] );
			}
		}
		
		if ( failed.size() != 0  )
		{
		    assert false : "Failures: " + NEWLINE + CollectionUtil.toString( failed, NEWLINE );
		}
		
		printElapsed( "testAttributeNamesAttributeCorrect", objectNames.length, start );
	}
	
		public void
	testBulkGetMBeanAttributeNames()
		throws Exception
	{
		final long	start	= now();
		
		final ObjectName[]	objectNames	= getTestUtil().getAllAMXArray();
		
		final Object[]	nameArrays	=
			getBulkAccess().bulkGetAttributeNames( objectNames );
		
		for( int i = 0; i < nameArrays.length; ++i )
		{
			final String[]	bulkNames	= (String[])nameArrays[ i ];
			
			final MBeanInfo	info =
				getConnection().getMBeanInfo( objectNames[ i ] );
				
			final String[]	names	= 
				JMXUtil.getAttributeNames( info.getAttributes() );
				
			assert( ArrayUtil.arraysEqual( names, bulkNames ) );
		}
		
		printElapsed( "testBulkGetMBeanAttributeNames", objectNames.length, start );
	}
	
		public void
	testBulkGetAttribute()
		throws Exception
	{
		final long	start	= now();
		
		final String		attrName	= AMXAttributes.ATTR_OBJECT_NAME;
		final ObjectName[]	objectNames	= getTestUtil().getAllAMXArray();
		
		final Object[]	values	=
			getBulkAccess().bulkGetAttribute( objectNames, attrName );
		
		final MBeanServerConnection	conn	= getConnection();
		for( int i = 0; i < objectNames.length; ++i )
		{
			final Object	value	= conn.getAttribute( objectNames[ i ], attrName );
				
			assertEquals( values[ i ], value );
		}
		
		printElapsed( "testBulkGetAttribute", objectNames.length, start );
	}
	
	
		public void
	testBulkGetAttributes()
		throws Exception
	{
		final long	start	= now();
		
		final String[]		attrNames	=  new String[] {
		    "FullType", "Group", "Name", "DomainRootObjectName", "ContainerObjectName" };
		final ObjectName[]	objectNames	= getTestUtil().getAllAMXArray();
		
		final Object[]	values	=
			getBulkAccess().bulkGetAttributes( objectNames, attrNames );
		
		final MBeanServerConnection	conn	= getConnection();
		for( int i = 0; i < objectNames.length; ++i )
		{
			final AttributeList	bulkAttrs	= (AttributeList)values[ i ];
			
			final AttributeList	attrs	= (AttributeList)conn.getAttributes( objectNames[ i ], attrNames );
				
			assertEquals( bulkAttrs, attrs );
		}
		printElapsed( "testBulkGetAttributes", objectNames.length, start );
	}

}


