/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.base;

import java.util.Set;

import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;

import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.base.AMX;

import com.sun.enterprise.management.AMXTestBase;


/**
 */
public final class ListenerTest extends AMXTestBase
{
    public ListenerTest()
    {
    }

    private static class DummyListener implements NotificationListener
    {
        public DummyListener()  {}
        
            public void
        handleNotification(
            final Notification notif,
            final Object handback )
        {
        }
    }
    
	    public void
	testAddRemoveNotificationListener()
	    throws Exception
	{
	    final long  start   = now();
	    final Set<AMX>  all = getAllAMX();
	    
	    final NotificationListener  listener1    = new DummyListener();
	    final NotificationListener  listener2    = new DummyListener();
	    
	    final NotificationFilter    filter  = new NotificationFilterSupport();
	    final Object    handback    = "handback";
	    
	    for( final AMX amx : all )
	    {
	        amx.getNotificationInfo();
	        amx.addNotificationListener( listener1, null, null );
	        amx.addNotificationListener( listener2, filter, handback );
	    }
	    
	    for( final AMX amx : all )
	    {
	        amx.removeNotificationListener( listener1 );
	        amx.removeNotificationListener( listener2, filter, handback );
	    }
	    
	    printElapsed( "Added/removed NotificationListener", all.size(), start );
	}
	
	
 
}


