/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/base/NotificationServiceMgrTest.java,v 1.3 2005/12/25 03:41:25 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:41:25 $
 */
package com.sun.enterprise.management.base;

import java.util.Set;

import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;

import com.sun.appserv.management.base.NotificationServiceMgr;
import com.sun.appserv.management.base.NotificationService;
import com.sun.appserv.management.base.Util;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class NotificationServiceMgrTest extends AMXTestBase
{
		public
	NotificationServiceMgrTest( )
	{
	}

	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( true );
	}
		public void
	testGet()
	{
		assert(  getNotificationServiceMgr() != null );
	}

		public void
	testCreateRemove()
		throws Exception
	{
		final NotificationServiceMgr	proxy	= getNotificationServiceMgr();
		
		final NotificationService	service	= proxy.createNotificationService( "test1", 512 );
		
		final ObjectName	objectName	= Util.getObjectName( service );
		
		proxy.removeNotificationService( service.getName() );
		assert( ! getConnection().isRegistered( objectName ) );
	}


}


