/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.io.IOException;
import java.util.Set;
import java.util.Map;
import java.util.Collections;

import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.RequestProcessingConfig;
import com.sun.appserv.management.config.KeepAliveConfig;
import com.sun.appserv.management.config.HTTPFileCacheConfig;
import com.sun.appserv.management.config.HTTPProtocolConfig;
import com.sun.appserv.management.config.AccessLogConfig;
import com.sun.appserv.management.config.ConnectionPoolConfig;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class HTTPServiceConfigTest extends AMXTestBase
{
		public HTTPServiceConfigTest ()
	{
	}

		synchronized final HTTPServiceConfig
	proxy() throws IOException
	{
	    return getConfigConfig().getHTTPServiceConfig();
	}

	static final Map<String,String> EMPTY_MAP = Collections.emptyMap();

		public void
	testRequestProcessing()
		throws Exception
	{
	    if ( ! checkNotOffline( "testRequestProcessing" ) )
	    {
	        return;
	    }
	    
		RequestProcessingConfig on = proxy().getRequestProcessingConfig();
		boolean exists = (on != null);
		if (!exists)
		{
			on = proxy().createRequestProcessingConfig(EMPTY_MAP);
			assert on == proxy().getRequestProcessingConfig();
		}
		RequestProcessingConfig rp = proxy().getRequestProcessingConfig();
		assert rp != null;
		if (!exists) { proxy().removeRequestProcessingConfig(); }
	}

		public void
	testKeepAlive()
		throws Exception
	{
	    if ( ! checkNotOffline( "testKeepAlive" ) )
	    {
	        return;
	    }
	    
		KeepAliveConfig on = proxy().getKeepAliveConfig();
		boolean exists = (on != null);
		if (!exists)
		{
			on = proxy().createKeepAliveConfig(EMPTY_MAP);
			assert on == proxy().getKeepAliveConfig();
		}
		KeepAliveConfig rp = proxy().getKeepAliveConfig();
		assert rp != null;
		if (!exists) { proxy().removeKeepAliveConfig(); }
	}

		public void
	testAccessLog()
		throws Exception
	{
	    if ( ! checkNotOffline( "testAccessLog" ) )
	    {
	        return;
	    }
	    
		AccessLogConfig on = proxy().getAccessLogConfig();
		boolean exists = (on != null);
		if (!exists)
		{
			on = proxy().createAccessLogConfig(EMPTY_MAP);
			assert on == proxy().getAccessLogConfig();
		}
		AccessLogConfig rp = proxy().getAccessLogConfig();
		assert rp != null;
		if (!exists) { proxy().removeAccessLogConfig(); }
	}

		public void
	testHTTPFileCache()
		throws Exception
	{
	    if ( ! checkNotOffline( "testHTTPFileCache" ) )
	    {
	        return;
	    }
	    
		HTTPFileCacheConfig on = proxy().getHTTPFileCacheConfig();
		boolean exists = (on != null);
		if (!exists)
		{
			on = proxy().createHTTPFileCacheConfig(EMPTY_MAP);
			assert on == proxy().getHTTPFileCacheConfig();
		}
		HTTPFileCacheConfig rp = proxy().getHTTPFileCacheConfig();
		assert rp != null;
		if (!exists) { proxy().removeHTTPFileCacheConfig(); }
	}

		public void
	testConnectionPool()
		throws Exception
	{
	    if ( ! checkNotOffline( "testConnectionPool" ) )
	    {
	        return;
	    }
	    
		ConnectionPoolConfig on = proxy().getConnectionPoolConfig();
		boolean exists = (on != null);
		if (!exists)
		{
			on = proxy().createConnectionPoolConfig(EMPTY_MAP);
			assert on == proxy().getConnectionPoolConfig();
		}
		ConnectionPoolConfig rp = proxy().getConnectionPoolConfig();
		assert rp != null;
		if (!exists) { proxy().removeConnectionPoolConfig(); }
	}

		public void
	testHTTPProtocol()
		throws Exception
	{
	    if ( ! checkNotOffline( "testHTTPProtocol" ) )
	    {
	        return;
	    }
	    
		HTTPProtocolConfig on = proxy().getHTTPProtocolConfig();
		boolean exists = (on != null);
		if (!exists)
		{
			on = proxy().createHTTPProtocolConfig(EMPTY_MAP);
			assert on == proxy().getHTTPProtocolConfig();
		}
		HTTPProtocolConfig rp = proxy().getHTTPProtocolConfig();
		assert rp != null;
		if (!exists) { proxy().removeHTTPProtocolConfig(); }
	}
}


