/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Collections;
import java.util.Map;

import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.JDBCConnectionPoolConfig;
import com.sun.appserv.management.config.JDBCResourceConfig;

/**
 */
public final class JDBCResourceConfigTest extends ResourceConfigTestBase
{
    private static final String JDBC_RESOURCE_POOL_NAME_BASE = "JDBCResourceConfigMgrTest.test-pool";
    private static final String JDBC_DATASOURCE_CLASSNAME = "com.pointbase.xa.xaDataSource";
    private static final Map<String,String> OPTIONAL    = null;
    
	private JDBCConnectionPoolConfig	mPool;
	
    public JDBCResourceConfigTest()
    {
    	mPool	= null;
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getDomainConfig() );
	    }
    }
    
        public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "JDBCResourceConfig" );
    }
    
         public static JDBCResourceConfig
	ensureDefaultInstance( final DomainConfig domainConfig )
	{
	    JDBCResourceConfig   result  =
	        domainConfig.getJDBCResourceConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        final JDBCConnectionPoolConfig  pool = 
	            JDBCConnectionPoolConfigTest.ensureDefaultInstance( domainConfig );
	            
	        result  = createInstance( domainConfig,
	            getDefaultInstanceName(), pool.getName(), OPTIONAL );
	    }
	    
	    return result;
	}
	
	    public static JDBCResourceConfig
	createInstance(
	    final DomainConfig  domainConfig,
	    final String        name,
	    final String        datasourceClassname,
	    final Map<String,String> optional )
	{
	    return  domainConfig.createJDBCResourceConfig(
	            name, datasourceClassname, optional );
	}
	
	
    	protected Container
	getProgenyContainer()
	{
		return getDomainConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.JDBC_RESOURCE_CONFIG;
	}


		protected void
	removeProgeny( final String name )
	{
		getDomainConfig().removeJDBCConnectionPoolConfig( name );
	}
	
    	protected String
	getProgenyTestName()
	{
		return( "jdbc/JDBCResourceConfigMgrTest" );
	}
	
		private JDBCConnectionPoolConfig
	createPool( final String name )
	{
		try
		{
			getDomainConfig().removeJDBCConnectionPoolConfig( name );
		}
		catch( Exception e )
		{
		}
		
	    final JDBCConnectionPoolConfig	config	=
	    	getDomainConfig().createJDBCConnectionPoolConfig( name, JDBC_DATASOURCE_CLASSNAME, null );
	    
	    return( config );
	}
    
		protected final AMXConfig
	createProgeny(final String name, final Map<String,String> options )
	{
		mPool	= createPool( name + "-temppool" );
		
	    final JDBCResourceConfig	config	=
	    	getDomainConfig().createJDBCResourceConfig( name, mPool.getName(), options);
		assert( config != null );
			    
		addReference( config );

		return( config );
	}
    
		protected final void
	remove(String name) 
	{
		getDomainConfig().removeJDBCResourceConfig( name );
		
		if ( mPool != null )
		{
			getDomainConfig().removeJDBCConnectionPoolConfig( mPool.getName() );
			mPool	= null;
		}
	}
 
}


