/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import javax.management.*;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;
import com.sun.enterprise.management.ClusterSupportRequired;

/**
  Unit test class to create-delete lb-config and load-balancer elements
 */
public final class LBTest extends AMXTestBase 
    implements ClusterSupportRequired
{

    final boolean runDels = true;
    final boolean runCreates = true;
    final boolean testGetLoadBalancerConfigMap = false;
    
    public LBTest() {}

    public void testCreateLBConfig() {
        if ( checkNotOffline( "testDeleteLBConfig" ) ) {
            if (!runCreates) return;
            String name = "test-lb-config";
            boolean monitoringEnabled = true;
            boolean routeCookieEnabled = false;
            boolean httpsRouting = false;
            String responseTimeout = "130";
            String reloadInterval = "380";        

            Map<String,String> params = new HashMap<String,String>();
            //params.put("name", name);
            params.put("route-cookie-enabled", "" + routeCookieEnabled);
            params.put("monitoring-enabled", "" + monitoringEnabled);
            params.put("https-routing", "" + httpsRouting);
            params.put("response-timeout-in-seconds", responseTimeout);
            params.put("reload-poll-interval-in-seconds", reloadInterval);

            try {
                getDomainConfig().createLBConfig(name, params);
            } catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void testCreateLoadBalancerConfig() {
	if ( checkNotOffline( "testDeleteLBConfig" ) ) {
            if (!runCreates) return;
            String name = "test-load-balancer";
            String lbConfigName = "test-lb-config";
            boolean autoApplyEnabled = true;
            Map<String,String> optional = null;
            try {
                getDomainConfig().createLoadBalancerConfig(name, lbConfigName, autoApplyEnabled, optional);
            } catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void testGetLBConfigMap() {
        try {
            Map map = getDomainConfig().getLBConfigMap();
            //System.out.println("Here is a list of Load Balancer Config MBeans in DAS: ");
            //System.out.println(map);
        } catch (Throwable t) {
            t.printStackTrace();
        }   
    }    
    
    public void testGetLoadBalancerConfigMap() {
	if (testGetLoadBalancerConfigMap==false) return;
        try {
            Map map = getDomainConfig().getLoadBalancerConfigMap();
            //System.out.println("Here is a list of Load Balancer Config MBeans in DAS: ");
            //System.out.println(map);
            ObjectName objName = new ObjectName("amx:j2eeType=X-LoadBalancerConfig,name=test-load-balancer");
            MBeanInfo minfo = getConnection().getMBeanInfo(objName);
            MBeanAttributeInfo[] mattrsinfo = minfo.getAttributes();
            /*
            for (MBeanAttributeInfo mattrinfo : mattrsinfo) 
            {
                System.out.println("Attribute Name is : " + mattrinfo.getName());
            }
            */
            
            String[] attrsNames = (String[]) getConnection().getAttribute(objName, "AttributeNames");
            /*for (String attrName : attrsNames) 
                System.out.println("Actual Attribute Name is : " + attrName);            
            System.out.println("AttributeNames are : " + attrsNames);
            System.out.println("MBeanInfo is \n"+minfo);*/
            
            String attrName = (String) getConnection().getAttribute(objName, "LbConfigName");
            System.out.println("attrName is = "+attrName);
	} catch (Throwable t) {
            t.printStackTrace();
        }   
    }

    public void testDeleteLoadBalancerConfig() {
        if ( checkNotOffline( "testDeleteLBConfig" ) ) {
            
            if (!runDels) return;
            String name = "test-load-balancer";
            try {
                getDomainConfig().removeLoadBalancerConfig(name);
            } catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void testDeleteLBConfig() {
        if ( checkNotOffline( "testDeleteLBConfig" ) ) {
            
            if (!runDels) return;
            String name = "test-lb-config";
            try {
                getDomainConfig().removeLBConfig(name);
            } catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}
