/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.deploy;

import java.util.HashMap;
import java.util.Map;

import java.io.IOException;
import java.io.Serializable;

import com.sun.appserv.management.deploy.DeploymentProgress;
import com.sun.appserv.management.deploy.DeploymentProgressImpl;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class DeploymentProgressTest extends junit.framework.TestCase
{
		public
	DeploymentProgressTest( )
	{
	}
	
	
	
		public DeploymentProgressImpl
	createDeploymentProgress()
	{
		final Object	id	= "deploy:999";
		
		final DeploymentProgressImpl	dp	=
			new DeploymentProgressImpl( (byte)99, "description", null );
		
		return( dp );
	}
	
		public void
	testCreateDeploymentProgress()
	{
		createDeploymentProgress();
	}
	
	
		public void
	testDeploymentProgressAsMap()
	{
		final DeploymentProgressImpl	dp	= createDeploymentProgress();
		
		final Map<String,Serializable>	data	= dp.asMap();
	}
	
		public void
	testDeploymentProgressFromMap()
	{
		final DeploymentProgressImpl	dp	= createDeploymentProgress();
		
		final Map<String,Serializable>	data = dp.asMap();
		
		final DeploymentProgressImpl dp2	= new DeploymentProgressImpl( data );
		
		assert( dp2.equals( dp ) );
	}
	
	
	
}
