/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.ext.offline;

import java.util.Set;
import java.util.HashSet;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.offline.OfflineDottedNamesRegistry;


/**
 */
public final class OfflineDottedNamesRegistryTest extends junit.framework.TestCase
{
        public
    OfflineDottedNamesRegistryTest()
    {
    }

        private OfflineDottedNamesRegistry
    create()
    {
        return new OfflineDottedNamesRegistry();
    }
    
    
        private ObjectName
    createObjectName( final String j2eeType, final String name)
    {
        return Util.newObjectName( "amx", Util.makeRequiredProps( j2eeType, name ) );
    }
    
		public void
	testCreate()
	{
	    create();
	}
	
	    private Set<String>
	dummySet()
	{
	    return GSetUtil.newStringSet( "hello", "there" );
	}
	
	
		public void
	testIllegalAdd()
	{
	    final OfflineDottedNamesRegistry    reg = create();
	    
	    try
	    {
	        reg.addMapping( null, "foo", dummySet() );
	        assert false : "Expected exception adding null ObjectName";
	    }
	    catch ( Exception e )
	    {
	    }
	    
	    try
	    {
	        reg.addMapping( createObjectName( "XXX", "ZZZ" ), null, dummySet() );
	        assert false : "Expected exception adding null prefix";
	    }
	    catch ( Exception e )
	    {
	    }
	    
	    try
	    {
	        reg.addMapping( createObjectName( "XXX", "ZZZ" ), "foo", null );
	        assert false : "Expected exception adding null attributes";
	    }
	    catch ( Exception e )
	    {
	    }
	    
	    try
	    {
	        reg.addMapping( createObjectName( "XXX", "ZZZ" ), "foo", dummySet() );
	        // try to add again
	        reg.addMapping( createObjectName( "XXX", "ZZZ" ), "foo", dummySet() );
	        assert false : "Expected exception adding same ObjectName";
	    }
	    catch ( Exception e )
	    {
	    }
	}
	
	
		public void
	testAddRemove()
	{
	    final OfflineDottedNamesRegistry    reg = create();
	    
	    final int ITER  = 1000;
	    
	    final Set<String>   attrs   = dummySet();
	    final ObjectName[]  objectNames = new ObjectName[ ITER ];
	    final String[]      prefixes = new String[ ITER ];
	    
	    for( int i = 0; i < ITER; ++i )
	    {
	        final String prefix = "foo" + i;
	        final ObjectName objectName = createObjectName( "test" + i, "" + i );

	        objectNames[ i ]    = objectName;
	        prefixes[ i ]       = prefix;
	        
	        reg.addMapping( objectName, prefix, attrs );
    	    assert( reg.getPrefix( objectName ) ==  prefix );
    	    assert( reg.getObjectName( prefix ) == objectName );
    	    assert( reg.getLegalAttributes( objectName ).equals( attrs ) );
	    }
	    
	    for( int i = 0; i < ITER; ++i )
	    {
	        final ObjectName    objectName  = objectNames[ i ];
	        final String        prefix  = prefixes[ i ];
	        
    	    assert( reg.getPrefix( objectName ) ==  prefix );
    	    assert( reg.getObjectName( prefix ) == objectName );
    	    assert( reg.getLegalAttributes( objectName ).equals( attrs ) );
	        
    	    reg.removeMapping( objectName );
    	    
    	    assert( reg.getPrefix( objectName) == null );
    	    assert( reg.getObjectName( prefixes[ i ] ) == null );
    	    assert( reg.getLegalAttributes( objectName ) == null );
	    }
	}
}






















