/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/monitor/ConnectionPoolStatsTest.java,v 1.4 2005/12/25 03:41:54 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:41:54 $
 */
package com.sun.enterprise.management.monitor;

import java.util.Set;
import java.util.Iterator;

import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.RangeStatistic;

import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.monitor.statistics.ConnectionPoolStats;
import com.sun.appserv.management.monitor.MonitoringStats;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


abstract class ConnectionPoolStatsTest extends AMXMonitorTestBase
{
    	public
    ConnectionPoolStatsTest()
    {
    }
  	
    
    protected abstract void	nextMonitor( final MonitoringStats ms);
    
  		protected int
  	iterateAllMonitors( final String j2eeType )
  	{
  		final Set	monitors	= getQueryMgr().queryJ2EETypeSet( j2eeType );
  		final Iterator	iter	= monitors.iterator();
  		
  		int	numMonitors	= 0;
  		while ( iter.hasNext() )
  		{
  			final MonitoringStats ms	= (MonitoringStats)iter.next();
  			++numMonitors;
  			nextMonitor( ms );
  		}
  		
  		return numMonitors;
  	}
  	
    /**
    	Verify that every Statistic can be successfully accessed.
     */
    	protected void
    accessAllStatistics( final ConnectionPoolStats s )
    {
	    final RangeStatistic r1	= s.getNumConnUsed();
	    assert( r1 != null );
	    
	    final RangeStatistic r2	= s.getNumConnFree() ;
	    assert( r2 != null );
	    
		final RangeStatistic r3 = s.getConnRequestWaitTime();
	    assert( r3 != null );

	    final CountStatistic c1 = s.getNumConnFailedValidation() ;
	    assert( c1 != null );
	    
	    final CountStatistic c2 = s.getNumConnTimedOut();
	    assert( c2 != null );
	    
		final CountStatistic c3 = s.getWaitQueueLength();
	    assert( c3 != null );
	    
		final CountStatistic c4	= s.getNumConnCreated();
	    assert( c4 != null );
	    
		final CountStatistic c5	= s.getNumConnDestroyed();
	    assert( c5 != null );
		
		//final CountStatistic c6	= s.getNumConnOpened();
	   // assert( c6 != null );
	    
		//final CountStatistic c7	= s.getNumConnClosed();
	   // assert( c7 != null );
	    
		final CountStatistic c8 = s.getAverageConnWaitTime();
	    assert( c8 != null );
    }
 
}






