/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.util.jmx;


import java.util.Set;
import java.util.HashSet;
import java.util.Collections;

import javax.management.ObjectName;

import com.sun.appserv.management.util.jmx.ObjectNameQuery;
import com.sun.appserv.management.util.jmx.ObjectNameQueryImpl;



public class ObjectNameQueryImplTest extends junit.framework.TestCase
{
    
            public
    ObjectNameQueryImplTest()
    {
        super( "ObjectNameQueryImplTest" );
    }

            public
    ObjectNameQueryImplTest( String name )
    {
        super( name );
    }
                public void
	testCreation()
	{
		new ObjectNameQueryImpl();
	}
	
	static final Set<ObjectName> EmptySet	= Collections.unmodifiableSet( new HashSet<ObjectName>() );
	static final String []	EmptyStrings	= new String [0];
	
		static Set<ObjectName>
	createSet( ObjectName name )
	{
		final Set<ObjectName>	s	= new HashSet<ObjectName>();
		
		s.add( name );
		
		return( s );
	}
	
		static Set<ObjectName>
	createSet( ObjectName [] names )
	{
		final Set<ObjectName>	s	= new HashSet<ObjectName>();
		
		for( int i = 0; i < names.length; ++i )
		{
			s.add( names[ i ] );
		}
		
		return( s );
	}
	
	
		static ObjectName
	createName( String nameString )
	{
		ObjectName	name	= null;
		
		try
		{
			name	= new ObjectName( nameString );
		}
		catch( Exception e )
		{
			assert( false );
		}
		return( name );
	}
	
		public void
	testEmptySet()
	{
		final ObjectNameQuery	q	= new ObjectNameQueryImpl();
		
		assertEquals( 0, q.matchAny( EmptySet, null, null ).size() );
		assertEquals( 0, q.matchAny( EmptySet, EmptyStrings, EmptyStrings ).size() );
		assertEquals( 0, q.matchAny( EmptySet, null, EmptyStrings ).size() );
		assertEquals( 0, q.matchAny( EmptySet, EmptyStrings, null ).size() );
		
		assertEquals( 0, q.matchAll( EmptySet, null, null ).size() );
		assertEquals( 0, q.matchAll( EmptySet, EmptyStrings, EmptyStrings ).size() );
		assertEquals( 0, q.matchAll( EmptySet, null, EmptyStrings ).size() );
		assertEquals( 0, q.matchAll( EmptySet, EmptyStrings, null ).size() );
	}
	
		public void
	testSingleItem()
	{
		final ObjectName	name1	= createName( ":name=test,type=test" );
		final Set<ObjectName>			testSet	= createSet( name1 );
		
		final ObjectNameQuery	q	= new ObjectNameQueryImpl();
		
		assertEquals( 1, q.matchAny( testSet,
			null,
			null ).size() );
		
		assertEquals( 1, q.matchAny( testSet, 
			new String [] { "type" },
			new String [] { "test" } ).size() );
			
		assertEquals( 1, q.matchAny( testSet, 
			new String [] { "type" },
			null ).size() );
			
		assertEquals( 1, q.matchAny( testSet, 
			null,
			new String [] { "test" } ).size() );
			
			
		assertEquals( 1, q.matchAny( testSet, 
			new String [] { "t.*" },
			new String [] { ".*e.*" } ).size() );
			
			
		assertEquals( 1, q.matchAny( testSet, 
			null,
			new String [] { ".*e.*" } ).size() );
		
		
		assertEquals( 0, q.matchAny( testSet, EmptyStrings, EmptyStrings ).size() );
		assertEquals( 0, q.matchAny( testSet, null, EmptyStrings ).size() );
		assertEquals( 0, q.matchAny( testSet, EmptyStrings, null ).size() );
	}
}






