/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.util.misc;

import java.util.Set;

import com.sun.appserv.management.util.misc.SetUtil;

public final class SetUtilTest extends junit.framework.TestCase
{
		public
	SetUtilTest()
	{
	}
	
	
	private static final String S1  = "hello";
	private static final String S2  = "there";
	private static final String S3  = "how";
	private static final String S4  = "are";
	
	    public void
	testMultiNew()
	{
	    Set<String>   s;
	    
	    s   = SetUtil.newSingletonSet( S1 );
	    assertEquals( S1, s.iterator().next() );
	    
	    s   = SetUtil.newSet( S1, S2 );
	    assert(s.contains( S1 ) );
	    assert(s.contains( S2 ) );
	    
	    s   = SetUtil.newSet( S1, S2, S3 );
	    assert(s.contains( S1 ) );
	    assert(s.contains( S2 ) );
	    assert(s.contains( S3 ) );
	    
	    s   = SetUtil.newSet( S1, S2, S3, S4 );
	    assert(s.contains( S1 ) );
	    assert(s.contains( S2 ) );
	    assert(s.contains( S3 ) );
	    assert(s.contains( S4 ) );
	    
	    final Set<String>   strings   = s;
	    final Set<Integer>  integers   = SetUtil.newSingletonSet( new Integer(3) );
	    
	    final Set<?>   both    = SetUtil.newSet( strings, integers );
	}
	

        public void
	testCopy()
	{
	    final Set<String>   s = SetUtil.newSingletonSet( S1 );
	    final Set<String>   sCopy   = SetUtil.copySet( s );
	    assertEquals( s, sCopy );
	    assertEquals( sCopy, s );
	    assertEquals( S1, SetUtil.getSingleton( s ) );
	    assertEquals( S1, SetUtil.getSingleton( sCopy ) );
	}
	
	  public void
	testGetSingleton()
	{
	    final Set<String>   s = SetUtil.newSingletonSet( S1 );
	    
	    assertEquals( S1, SetUtil.getSingleton( s ) );
	    
	    s.add( S2 );
	    try
	    {
	        SetUtil.getSingleton( s );
	        fail( "expecting exception" );
	    }
	    catch (IllegalArgumentException e)
	    {
	    }
	}
	
	
}






