/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameServerInfoCache.java,v 1.3 2005/12/25 03:42:04 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:04 $
 */
package com.sun.enterprise.admin.dottedname;

import java.util.HashMap;
import java.util.Set;
import java.util.Iterator;
import java.util.Collections;

import javax.management.ObjectName;

/*
	This class maintains a cache of the current server info as an optimization.
	
	The user should call refresh() prior to first use, and when wishing to get
	the current state.
	
 */
public class DottedNameServerInfoCache implements DottedNameServerInfo
{
	final DottedNameServerInfo	mSrc;
	
	Set			mConfigNames;
	Set			mServerNames;
	HashMap		mServerToConfig;
	HashMap		mConfigToServers;
	
		public
	DottedNameServerInfoCache( final DottedNameServerInfo src )
	{
		mSrc	= src;
		
		// underlying source may or may not be ready yet, so it's up
		// to the caller to call refresh() before first use.
		mConfigNames	= Collections.EMPTY_SET;
		mServerNames	= Collections.EMPTY_SET;
		mServerToConfig	= mConfigToServers	= new HashMap();
	}
	
		public synchronized Set
	getConfigNames()
		throws DottedNameServerInfo.UnavailableException
	{
		return( mConfigNames );
	}
	
		public synchronized Set
	getServerNames()
		throws DottedNameServerInfo.UnavailableException
	{
		return( mServerNames );
	}
	
		public synchronized String
	getConfigNameForServer( String serverName )
		throws DottedNameServerInfo.UnavailableException
	{
		return( (String)mServerToConfig.get( serverName ) );
	}
	
		public synchronized String []
	getServerNamesForConfig( String configName )
		throws DottedNameServerInfo.UnavailableException
	{
		return( (String [])mConfigToServers.get( configName ) );
	}
	
		void
	_refresh()
		throws DottedNameServerInfo.UnavailableException
	{
		mConfigNames	= mSrc.getConfigNames();
		mServerNames	= mSrc.getServerNames();
		
		// create mapping from server to config
		Iterator	iter	= mServerNames.iterator();
		while ( iter.hasNext() )
		{
			final String	serverName	= (String)iter.next();
			
			final String	configName	= mSrc.getConfigNameForServer( serverName );
			
			if ( configName != null )
			{
				mServerToConfig.put( serverName, configName );
			}
		}
		
		// create mapping from config to servers
		iter	= mConfigNames.iterator();
		while ( iter.hasNext() )
		{
			final String	configName	= (String)iter.next();
			
			final String [] serverNames	= mSrc.getServerNamesForConfig( configName );
			
			if ( serverNames != null )
			{
				mConfigToServers.put( configName, serverNames );
			}
		}
	}
	
		public synchronized void
	refresh()
	{
		try
		{
			_refresh();
		}
		catch( DottedNameServerInfo.UnavailableException e )
		{
			DottedNameLogger.logException( e );
		}
	}
}









