/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/DottedNameWildcardMatcherImpl.java,v 1.3 2005/12/25 03:42:05 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:05 $
 */


package com.sun.enterprise.admin.dottedname;

import java.util.HashSet;
import java.util.Set;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

import javax.management.ObjectName;


/*
	Resolve a wildcarded dotted name.
 */
 
public class DottedNameWildcardMatcherImpl implements DottedNameWildcardMatcher
{
	final Set		mSearchSet;
	
		public
	DottedNameWildcardMatcherImpl( final Set	searchSet )
	{
		mSearchSet		= searchSet;
	}
	
	
	/*
		Return the set of all dotted names that match the specified wildcarded dotted name
	 */
		Set
	resolveAll( final String wildcardedName, final Iterator iter )
	{
		final HashSet	resolvedSet	= new HashSet();
		
		final Pattern	pattern	= Pattern.compile( wildcardedName );
		
		while ( iter.hasNext() )
		{
			final String	candidate	= (String)iter.next();
			
			if ( pattern.matcher( candidate ).matches() )
			{
				resolvedSet.add( candidate );
			}
		}
		
		return( resolvedSet );
	}

	/*
		IMPORTANT: the wildcard format must be that of java.util.regex
		
		@param dottedNameString	a string using java.util.regex format
	 */
		public Set
	matchDottedNames( String dottedNameString )
	{
		Set	resolvedSet	= null;
		
		if ( dottedNameString.equals( ".*" ) )
		{
			// optimization; match all
			resolvedSet	= new HashSet();
			resolvedSet.addAll( mSearchSet );
		}
		else
		{
			resolvedSet	= resolveAll( dottedNameString, mSearchSet.iterator() );
		}
		
		return( resolvedSet );
	}
}




