/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: IConnectorConnectionPoolMBean.java,v 1.3 2005/12/25 03:42:10 tcfujii Exp $
 * Author: Vishal Byakod (vb130608)
 */

package com.sun.enterprise.admin.mbeanapi;

import java.util.ArrayList;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.MBeanException;

public interface IConnectorConnectionPoolMBean {
    
    public void createSecurityMap(AttributeList attrList)
        throws Exception;
    
    public ObjectName createSecurityMap(AttributeList attrList,String userName,
        String password, String tgtName) 	throws MBeanException;
    
    public boolean updateSecurityMap(AttributeList attrList,String tgtName )
        throws MBeanException;    
    
    public ArrayList listSecurityMap(String mapName,Boolean verb,String poolName,
        String tgtName) throws MBeanException;
    
    public AttributeList getAttributes(String mapName,String poolName)
        throws Exception;         
}
