/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeanapi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.Map;
import java.util.Hashtable;
import java.lang.reflect.Method;

import javax.management.MBeanException;

import com.sun.enterprise.admin.common.ByteChunk;
import com.sun.enterprise.admin.common.DownloadRequestInfo;

public interface ISystemServicesMBean  {
      
    
    public String uploadToServer(ByteChunk byteChunk) throws MBeanException;
        
    public Object prepareDownload(String filePath) throws MBeanException;

    public DownloadRequestInfo mcPrepareDownload(String filePath) 
            throws MBeanException;
    
    public ByteChunk downloadFile(Integer chunkInteger) throws MBeanException;

    public DownloadRequestInfo mcDownloadFile(DownloadRequestInfo info) 
            throws MBeanException;
    
    public String getClientStubJarLocation(String appName)
        throws MBeanException;
}
