/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/mbeans/DottedNameRegistryMBeanImpl.java,v 1.3 2005/12/25 03:42:20 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:20 $
 */
package com.sun.enterprise.admin.mbeans;
 

import java.util.Set;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.NotCompliantMBeanException;


import com.sun.enterprise.admin.dottedname.*;

/*
	A registry for DottedName-to-ObjectName mapping.
 */
public class DottedNameRegistryMBeanImpl extends StandardMBean implements DottedNameRegistryMBean
{
	final DottedNameRegistry1To1Impl	mRegistry;
	
		public
	DottedNameRegistryMBeanImpl( )
		throws NotCompliantMBeanException
	{
		super( DottedNameRegistry.class );
		
		mRegistry	= new DottedNameRegistry1To1Impl();
	}
	
		public ObjectName
	dottedNameToObjectName( String dottedName )
	{
		return( mRegistry.dottedNameToObjectName( dottedName ) );
	}
	
		public String
	objectNameToDottedName( ObjectName objectName )
	{
		return( mRegistry.objectNameToDottedName( objectName ) );
	}
	
		public Set
	allDottedNameStrings(  )
	{
		final Set	tempNames	= mRegistry.allDottedNameStrings();
		Set			names	= null;
		
		if ( tempNames instanceof java.io.Serializable )
		{
			names	= tempNames;
		}
		else
		{
			names	= new java.util.HashSet();
			names.addAll( tempNames );
		}
		
		return( names );
	}
	
		public Set
	allObjectNames(  )
	{
		return( mRegistry.allObjectNames() );
	}

		public void
	add( String dottedName, ObjectName objectName )
	{
		mRegistry.add( dottedName, objectName );
	}
	
		public void
	remove( String dottedName )
	{
		mRegistry.remove( dottedName );
	}
	
		public void
	remove( ObjectName objectName )
	{
		mRegistry.remove( objectName );
	}
}

