/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.tx.TransactionsRecoveryEvent;

import com.sun.enterprise.server.ApplicationServer;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;

import com.sun.enterprise.util.i18n.StringManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.HashMap;
import java.util.logging.Level; 

/**
 * object name for this mbean: <domainName>:type=transactions-recovery,category=config
 * TransactionsRecoveryMBean sends request to transactions recovery
 *
 * @author alexkrav
 *
 */
public class TransactionsRecoveryMBean extends BaseConfigMBean
{
   
    public TransactionsRecoveryMBean()
    {
        super();
    }	
    
	///////////////////////////////////////////////////////////////////////////
    /**
     * Recovers transaction for given server instance
     *
     * @throws MBeanConfigException if not SUCCESS result of event handling
     *
     */
    public void recoverTransactions() throws MBeanConfigException
    {
        
        fine("TransactionsRecoverytMBean.recoveryTransactions for server");
	 
        sendTransactionsRecoveryEvent(getServerName(), getServerName(), null);
        
    }
	
    ///////////////////////////////////////////////////////////////////////////

 
   private void sendTransactionsRecoveryEvent(String destinationServer, String serverToRecover, 
                    String transactionLogDir) throws MBeanConfigException
   {
        AdminEvent event = new TransactionsRecoveryEvent(getServerName(), 
                    serverToRecover, 
                    transactionLogDir);
        event.setTargetDestination(destinationServer); 
        AdminEventResult res = forwardEvent(event);
        if(!AdminEventResult.SUCCESS.equals(res.getResultCode()))
        {
            Throwable exc = null;
            exc = res.getFirstThrowable();
            if (exc != null) {
                throw new MBeanConfigException(_strMgr.getString("tx.exceptionInTargetServer", 
                    exc.getMessage()));
            }
            throw new MBeanConfigException(_strMgr.getString("tx.notSuccessInSendReturn", 
                    res.getResultCode()));
        }
    }
      

     private AdminEventResult forwardEvent(AdminEvent e) {
        AdminEventResult result = null;
        result = AdminEventMulticaster.multicastEvent(e);
        return result;
    }
    
     private void fine(String s) {
         _sLogger.log(Level.FINE, s); 
     }

    private String getServerName() 
    {
        return ApplicationServer.getServerContext().getInstanceName();
    } 
     
	///////////////////////////////////////////////////////////////////////////
	
	private static final	StringManager	_strMgr = 
                StringManager.getManager(EJBTimerManagementMBean.class);
	///////////////////////////////////////////////////////////////////////////
                
}
