/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeans.custom;

import com.sun.enterprise.admin.mbeans.custom.loading.MBeanClassLoader;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/** Implements an algorithm to select the ObjectName given the various parameters. See Design Document for details.
 */
public class ObjectNameSelectionAlgorithm {
    
    private ObjectNameSelectionAlgorithm() {
    }
    public static ObjectName select(final Map<String, String> params) throws RuntimeException {
        ObjectName on = null;
        try {
            if (params.containsKey(CustomMBeanConstants.OBJECT_NAME_KEY))
                on = new ObjectName(params.get(CustomMBeanConstants.OBJECT_NAME_KEY));
            else { 
                /* WBN 
                 * note that we always form an ON.  For a CMB that implements 
                 * MBeanRegistration -- it may use that name or it may create its
                 * own name.  If it creates its own name, we'll see it soon and then use
                 * that name in preference to this one...
                 */
                on = MBeanValidator.formDefaultObjectName(params);
            }
            return ( on );
        } catch(final MalformedObjectNameException me) {
            throw new RuntimeException(me);
        }
    }
    
    public static boolean implementsMBeanRegistrationInterface(String className) throws RuntimeException {
        boolean imri = false;
        try {
            //Note that the bits of the class need to be loaded dynamically and hence we need MBeanClassLoader
            ClassLoader mbcl        = new MBeanClassLoader();
            Class mbc               = Class.forName(className, false, mbcl);
            final Class[] iifs      = mbc.getInterfaces();
            for (Class c : iifs) {
                if (javax.management.MBeanRegistration.class.equals(c)) {
                    imri = true;
                    mbc = null; mbcl = null; // make them garbage-collectible  asap :), purpose served
                    break;
                }
            }
        } catch (final Exception e) {
            throw new RuntimeException (e);
        }
        return ( imri );
    }
    
    private static boolean implementsMBeanRegistrationInterface(final Map<String, String> params) throws RuntimeException {
        return implementsMBeanRegistrationInterface(params.get(CustomMBeanConstants.IMPL_CLASS_NAME_KEY));
    }
}
