/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * JCAResource.java
 *
 * Created on March 5, 2002, 3:58 PM
 */

package com.sun.enterprise.management.model;

import java.util.Set;
import java.util.Iterator;
import javax.management.ObjectName;

public class JCAResourceMdl extends J2EEResourceMdl {

    private static String MANAGED_OBJECT_TYPE = "JCAResource";
    /** Creates new JCAResource */
    String resourceAdapter = null;
    String username = null;
    String password = null;
    String[] propNames = null;
    String[] propValues = null;
                        
    public JCAResourceMdl(String name, String raName,
                            String username, String password,
                            String[] propNames, String[] propValues) {
        super(name);
        resourceAdapter = raName;
        this.username = username;
        this.password = password;
        this.propNames = propNames;
        this.propValues = propValues;
    }
    public JCAResourceMdl(String name, String serverName, String raName,
                            String username, String password,
                            String[] propNames, String[] propValues) {
        super(name, serverName);
        resourceAdapter = raName;
        this.username = username;
        this.password = password;
        this.propNames = propNames;
        this.propValues = propValues;
    }
    
    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this
     * method and return the appropriate type string.
     */
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }
    
    public String[] getconnectionFactories(){
        Set s = findNames("j2eeType=JCAConnectionFactory,J2EEServer="+ this.getJ2EEServer() + ",JCAResource=" + getname());
        Iterator it = s.iterator();
        String [] ret = new String[s.size()];
        int i =0;
        while(it.hasNext()) {
            ret[i++] = ((ObjectName)it.next()).toString();
        }
        return ret;
    }
    
    public String getresourceAdapter() {
        return resourceAdapter;
    }

    public String getusername() {
        return username;
    }

    public String getpassword() {
        return password;
    }

    public String[] getpropNames() {
        return propNames;
    }

    public String[] getpropValues() {
        return propValues;
    }
}
