/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.pluggable;

import com.sun.enterprise.pluggable.Utils;

import java.util.Properties;

import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.diagnostics.DiagnosticAgent;

/**
 * Properties that define implementation classes for pluggable features
 * used asadmin specific to PE (platform edition) version of the product . 
 * An instance of this class should be passed to getInstance() 
 * method of ClientPluggableFeatureFactoryImpl
 * to create and have access to pluggable features.
 */
public class PEClientPluggableFeatureImpl extends Properties {

    /**
     * Properties to keep feature name and implementation classes.
     */
    private static Properties featureImplClasses;

    static {
        Properties props = new Properties();
        props.setProperty(
            Utils.getNQClassName(DomainsManager.class),
            "com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager");
        props.setProperty(
            Utils.getNQClassName(DiagnosticAgent.class),
            "com.sun.enterprise.diagnostics.PEDiagnosticAgent");
        featureImplClasses = props;
    }

    /**
     * Default constructor. 
     */
    public PEClientPluggableFeatureImpl() {
        super(featureImplClasses);
    }

}
