/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt;

import java.util.BitSet;

/**
 */
public interface DomainsManager
{       
    /**
     * In SE/EE we need an admin user/password that the DAS can use to authenticate to 
     * Node Agents and servers in the domain. This is not the case in PE; hence
     * this flag -- DomainConfig.K_FLAG_START_DOMAIN_NEEDS_ADMIN_USER
     * 
     * In SE/EE we need an extra non secure http port to host the Lockhart components 
     * which is controlled by -- DomainConfig.K_FLAG_CREATE_DOMAIN_NEEDS_ALTERNATE_ADMIN_PORT
     * @return flags toggling SE/EE specific behavior.
     */    
    public BitSet getDomainFlags();
    
    /**
     * SE/EE supports NSS as its native SSL database. NSS is capable of supporting multiple
     * slots (e.g. for different SSL hardware devices, smartcards, etc). Each device 
     * needs a specific password which the CLI must prompt for.
     */
     public String[] getExtraPasswordOptions(DomainConfig config)
        throws DomainException;
           
    
    /**
     * Creates a domain     
     * @param domainConfig The configuration params that are required to create
     * the domain. (eg :- domain admin port, http port, default locale, 
     * domain root, install root etc.) The relevant keys are defined in 
     * DomainConfig. The implementors of this class should validate the values 
     * that are supplied.
     * @throws DomainException  This exception is thrown if 
     *  - the domain already exists.
     *  - an invalid or insufficient config. is supplied.
     *  - an exception occurred during domain creation.
     */
    public void createDomain(DomainConfig domainConfig) 
        throws DomainException;

    /**
     * Deletes a domain identified by the given name.
     * (Should we stop the DAS and instances administered by this domain before
     * deleting the domain?)     
     * @param domainConfig
     * @throws DomainException  This exception is thrown if 
     * <ul>
     * - the domain doesnot exist.
     * - an exception occurred while deleting the domain.
     * </ul>
     */
    public void deleteDomain(DomainConfig domainConfig) 
        throws DomainException;

    /**
     * Starts the Domain Administration Server (DAS) that administers the given
     * domain.     
     * @param startParams
     * @throws DomainException
     */
    public void startDomain(DomainConfig domainConfig) 
        throws DomainException;

    /**
     * Stops the Domain Administration Server (DAS) that administers the given
     * domain.     
     * @param domainConfig
     * @throws DomainException  
     */
    public void stopDomain(DomainConfig domainConfig) 
        throws DomainException;

    /**
     * Lists all the domains.
     */
    public String[] listDomains(DomainConfig domainConfig)
        throws DomainException;

    /**
     * Lists all the domains and their status
     */
    public String[] listDomainsAndStatus(DomainConfig domainConfig)
        throws DomainException;

    /**
     * Changes the master password for the domain
     */    
    public void changeMasterPassword(DomainConfig domainConfig) 
        throws DomainException;
    
    public void validateDomain(DomainConfig domainConfig, boolean domainExists)
        throws DomainException;
    
    public void validateMasterPassword(DomainConfig config) throws DomainException;
    
    public void validateAdminUserAndPassword(DomainConfig domainConfig) throws DomainException;
        
    /**
     */
    public InstancesManager getInstancesManager(RepositoryConfig config);
}
