/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PortValidator.java
 *
 * Created on August 11, 2003, 7:44 PM
 */

package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.util.i18n.StringManager;

import com.sun.enterprise.util.net.NetUtils;

/**
 * This validator ensures that the specified port is not in use.
 * @author  kebbs
 */
public class PortValidator extends Validator {

    private static final StringManager _strMgr = 
        StringManager.getManager(PortValidator.class);

    /** Creates a new instance of PortValidator */
    public PortValidator(String name) {
        super(name, java.lang.Integer.class);
    }
 
     /**
     * Validates the given Port.
     * @param str Must be the absolute path of the File that will be validated.
     * @throws InvalidConfigException
     */
    public void validate(Object obj) throws InvalidConfigException
    {
        super.validate(obj);
        if (!NetUtils.isPortFree(((Integer)obj).intValue())) {
            throw new InvalidConfigException(
                _strMgr.getString("portValidator.in_use", obj));
        }
    }
}
