/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * RuntimeStatus.java
 *
 * Created on February 27, 2004, 12:26 PM
 */

package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.common.Status;

import com.sun.enterprise.server.logging.FileandSyslogHandler;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.InstanceException;

import java.io.Serializable;
import java.util.Vector;
import com.sun.enterprise.util.LocalStrings;
import com.sun.enterprise.util.LocalStringsImpl;

/**
 *
 * @author  kebbs
 */
public class RuntimeStatus implements Serializable {
       
    private boolean _restartNeeded;
    private Status _status;
    private Vector _recentErrorMessages;                
    private String _name;
    
    public static RuntimeStatus getRuntimeStatus(
        String name,
        InstancesManager manager) throws InstanceException 
    {                
        int status = manager.getInstanceStatus();          
        return new RuntimeStatus(name, manager.isRestartNeeded(),
            new Status(status, Status.getStatusString(status)),
            FileandSyslogHandler.getRecentErrorMessages());        
    }       

    public static void clearRuntimeStatus() 
    {
        FileandSyslogHandler.clearRecentErrorMessages();
    }
    
    public RuntimeStatus() {         
        this ("", true, new Status(Status.kInstanceNotRunningCode, 
            Status.kInstanceNotRunningMsg), new Vector());
    }
    
    public RuntimeStatus(String name) {         
        this();
        _name = name;
    }
    
    public RuntimeStatus(String name, boolean restartNeeded, 
        Status status, Vector recentErrors)
    {
        _name = name;
        _restartNeeded = restartNeeded;
        _status = status;
        _recentErrorMessages = recentErrors;
    }
    
    public boolean isRestartNeeded()
    {
        return _restartNeeded;
    }
    
    public String getName()
    {
        return _name;
    }
    
    public void setStatus(Status status) 
    {
        _status = status;
    }
    
    public Status getStatus() 
    {
        return _status;
    }
    
    public Vector getRecentErrorMessages()
    {
        return _recentErrorMessages;
    }
    
    
    public boolean isRunning()
    {
        return getStatus().getStatusCode() == Status.kInstanceRunningCode ? true : false;        
    }
    
    public boolean isStopped()
    {
        return getStatus().getStatusCode() == Status.kInstanceNotRunningCode ? true : false;
    }
    
    public String toShortString()
    {
        String result = getStatus().getStatusString();
        if (isRunning()) {
            if (isRestartNeeded()) {
                result = LocalStrings.get("requiresRestartYes");
            } 
        } 
        return result;
    }
    
    public String toString()
    {
        LocalStringsImpl stringy = new LocalStringsImpl();
        String result = stringy.get("runtimeStatusToString", getName(), getStatus().getStatusString());
        if (isRestartNeeded()) {
            result += ", " + stringy.get("requiresRestartYes");
        } else {
            result += ", " + stringy.get("requiresRestartNo");
        }
        
        Vector messages = getRecentErrorMessages();
        for (int i = 0; i < messages.size(); i++) {
            result += "\n" + stringy.get("error") + " " + i + " " + (String)messages.get(i);
        }

        return result;
    }
    
}
    
