/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt;

import java.util.Map;

/** An interface to handle life cycle of a Service as recognized by an operating
 * platform.
 */
public interface ServiceHandler {
    
    /** Creates an arbitrary service, specified by certain parameters. The implementations
     * should dictate the mappings in the parameters received. The creation of service is
     * either successful or not. In other words, the implementations must retain the original
     * state of the operating platform if the service creation is not successful completely.
     * @param params a Map between Strings that represents the name value pairs required to create the service
     * @throws RuntimeException if there is any error is creation of service
     */
    public void createService(final Map<String, String> params) throws RuntimeException;
    
    /** Sets the trace flag. The ServiceHandler is expected to provide trace output if the flag is set.
     */
    public void setTrace(final boolean trace);
}