/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.util.i18n.StringManager;

/**
 * Base class for all domain config validators. Validates the non-null ness
 * of a domain config entry and its type.
 */
public class Validator
{
    /**
     * i18n strings manager object
     */
    private static final StringManager strMgr = 
        StringManager.getManager(Validator.class);

    /**
     * The accepted type of an entry.
     */
    private final Class type;

    /**
     * The name of an entry that is used in case of validation error.
     */
    private final String name;

    /**
     * Constructs new Validator object.
     * @param name Name of an entry that is used in case of validation errors.
     * If the name is null "" is used instead.
     * @param type 
     */
    public Validator(String name, Class type)
    {
        this.name = (name != null) ? name : "";
        this.type = (type != null) ? type : java.lang.Object.class;
    }

    /**
     * Returns the name of the entry.
     */
    public String getName()
    {
        return name;
    }

    /**
     * Checks the validity of the given value for the entry. This method does
     * basic checks such as null ness & type.
     * @param obj
     * @Throws InvalidConfigException
     */
    public void validate(Object obj) throws InvalidConfigException
    {
        if (obj == null)
        {
            throw new InvalidConfigException(
                strMgr.getString("validator.invalid_value", getName(), null));
        }
        Class c = obj.getClass();
        if (!type.isAssignableFrom(c))
        {
            throw new InvalidConfigException(
                strMgr.getString("validator.invalid_type", 
                    getName(), type.getName(), c.getName()));
        }
    }
}
