/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt.pe;

import java.io.File;

import com.sun.enterprise.util.io.FileUtils;

import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.admin.servermgmt.DomainConfig;

public final class PEAccXmlTokens
{
    public static final String SERVER_ROOT  = "SERVER_ROOT";

    public static final String SERVER_NAME  = "SERVER_NAME";

    public static final String ORB_LISTENER1_PORT = "ORB_LISTENER1_PORT"; 

    public static TokenValueSet getTokenValueSet(DomainConfig domainConfig)
    {       
        final PEFileLayout layout = new PEFileLayout(domainConfig);

        final TokenValueSet tokens = new TokenValueSet();

        final String installDir = layout.getInstallRootDir().getAbsolutePath();
        TokenValue tv = new TokenValue(SERVER_ROOT, 
                            FileUtils.makeForwardSlashes(installDir));
        tokens.add(tv);

        tv = new TokenValue(SERVER_NAME, 
                (String)domainConfig.get(DomainConfig.K_HOST_NAME));
        tokens.add(tv);

        final Integer orbPort = 
            (Integer)domainConfig.get(DomainConfig.K_ORB_LISTENER_PORT);
        tv = new TokenValue(ORB_LISTENER1_PORT, orbPort.toString());
        tokens.add(tv);

        return ( tokens );
    }
}
