/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt.pe;

import java.io.File;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.admin.servermgmt.DomainConfig;

public final class PEDomainXmlTokens
{
    public static final String CONFIG_MODEL_NAME_TOKEN_NAME  = "CONFIG_MODEL_NAME";
    public static final String CONFIG_MODEL_NAME_TOKEN_VALUE = "server-config";

    public static final String HOST_NAME_TOKEN_NAME          = "HOST_NAME";
    public static final String DOMAIN_NAME_TOKEN_NAME        = "DOMAIN_NAME";
    
    public static final String HTTP_PORT_TOKEN_NAME          = "HTTP_PORT";

    public static final String ORB_LISTENER_PORT_TOKEN_NAME  = "ORB_LISTENER_PORT";

    public static final String JMS_PROVIDER_PASSWORD_TOKEN_NAME= "JMS_PROVIDER_PASSWORD"; 
    
    public static final String JMS_PROVIDER_PORT_TOKEN_NAME= "JMS_PROVIDER_PORT"; 
    
    public static final String JMS_PROVIDER_USERID_TOKEN_NAME= "JMS_PROVIDER_USERID";     
    
    public static final String SERVER_ID_TOKEN_NAME= "SERVER_ID"; 

    public static final String ADMIN_PORT_TOKEN_NAME= "ADMIN_PORT";

    public static final String HTTP_SSL_PORT_TOKEN_NAME= "HTTP_SSL_PORT";

    public static final String ORB_SSL_PORT_TOKEN_NAME= "ORB_SSL_PORT";

    public static final String ORB_MUTUALAUTH_PORT_TOKEN_NAME= "ORB_MUTUALAUTH_PORT";

    //This token is used for SE/EE only now, but it is likely that we will want to expose it
    //in PE (i.e. to access the exposed Mbeans). Remember that the http jmx port (used by
    //asadmin) will not be exposed pubically.
    public static final String JMX_SYSTEM_CONNECTOR_PORT_TOKEN_NAME="JMX_SYSTEM_CONNECTOR_PORT";
    
    public static TokenValueSet getTokenValueSet(DomainConfig domainConfig)
    {
        final String  installRoot = 
        (String)domainConfig.get(DomainConfig.K_INSTALL_ROOT);
        final String  domainRoot  = 
        (String)domainConfig.get(DomainConfig.K_DOMAINS_ROOT);

        final TokenValueSet tokens = new TokenValueSet();

        String instanceName = (String)domainConfig.get(DomainConfig.K_SERVERID);
        if((instanceName == null) || (instanceName.equals("")))
            instanceName = PEFileLayout.DEFAULT_INSTANCE_NAME;

        TokenValue tv = new TokenValue(CONFIG_MODEL_NAME_TOKEN_NAME,
                                    CONFIG_MODEL_NAME_TOKEN_VALUE);
        tokens.add(tv);

        tv = new TokenValue(HOST_NAME_TOKEN_NAME, 
                (String)domainConfig.get(DomainConfig.K_HOST_NAME));
        tokens.add(tv);

        final Integer adminPort = 
            (Integer)domainConfig.get(DomainConfig.K_ADMIN_PORT);
        tv = new TokenValue(ADMIN_PORT_TOKEN_NAME, adminPort.toString());
        tokens.add(tv);

        final Integer httpPort = 
            (Integer)domainConfig.get(DomainConfig.K_INSTANCE_PORT);
        tv = new TokenValue(HTTP_PORT_TOKEN_NAME, httpPort.toString());
        tokens.add(tv);

        final Integer orbPort = 
            (Integer)domainConfig.get(DomainConfig.K_ORB_LISTENER_PORT);
        tv = new TokenValue(ORB_LISTENER_PORT_TOKEN_NAME, orbPort.toString());
        tokens.add(tv);

        tv = new TokenValue(JMS_PROVIDER_PASSWORD_TOKEN_NAME, 
              (String)domainConfig.get(DomainConfig.K_JMS_PASSWORD));
        tokens.add(tv);

        final Integer jmsPort = 
            (Integer)domainConfig.get(DomainConfig.K_JMS_PORT);
        tv = new TokenValue(JMS_PROVIDER_PORT_TOKEN_NAME, jmsPort.toString());
        tokens.add(tv);

        tv = new TokenValue(JMS_PROVIDER_USERID_TOKEN_NAME, 
              (String)domainConfig.get(DomainConfig.K_JMS_USER));
        tokens.add(tv);

        tv = new TokenValue(SERVER_ID_TOKEN_NAME, 
                                instanceName);
        tokens.add(tv);
 
        final Integer httpSslPort = 
            (Integer)domainConfig.get(DomainConfig.K_HTTP_SSL_PORT);
        tv = new TokenValue(HTTP_SSL_PORT_TOKEN_NAME, httpSslPort.toString());
        tokens.add(tv);

        final Integer orbSslPort = 
            (Integer)domainConfig.get(DomainConfig.K_IIOP_SSL_PORT);
        tv = new TokenValue(ORB_SSL_PORT_TOKEN_NAME, orbSslPort.toString());
        tokens.add(tv);

        final Integer orbMutualAuthPort = 
            (Integer)domainConfig.get(DomainConfig.K_IIOP_MUTUALAUTH_PORT);
        tv = new TokenValue(ORB_MUTUALAUTH_PORT_TOKEN_NAME, orbMutualAuthPort.toString());
        tokens.add(tv);

        final Integer jmxPort = 
            (Integer)domainConfig.get(DomainConfig.K_JMX_PORT);
        tv = new TokenValue(JMX_SYSTEM_CONNECTOR_PORT_TOKEN_NAME, jmxPort.toString());
        tokens.add(tv);

        tv = new TokenValue(DOMAIN_NAME_TOKEN_NAME, domainConfig.getRepositoryName());
        tokens.add(tv);

        
        return ( tokens );
    }
}
