/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt.pe;

import java.io.File;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.DomainXmlEventListener;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.i18n.StringManager;

/** The event listener class for PE Samples domain */
public class PESamplesDomainXmlEventListener implements DomainXmlEventListener {
    
    private static final StringManager strMgr =
    StringManager.getManager(PEDomainsManager.class);

    /** after the creation of domain.xml , unjar the bundled samples.jar. */    
    public void handleCreateEvent(DomainConfig cfg) throws DomainException {                        
        PEFileLayout layout = new PEFileLayout(cfg);
        File appsDir = layout.getInstallApplicationsDir();
        File domainDir = layout.getRepositoryDir();
        File jarFile = new File(appsDir, "samples.jar" );
        
        try{
            ZipFile file = new ZipFile(FileUtils.safeGetCanonicalPath(jarFile), 
                                        FileUtils.safeGetCanonicalPath(domainDir));
            file.explode();
        }catch(ZipFileException e){
            throw new DomainException( strMgr.getString("samplesDomainNotCreated") ,e );
        }
    }
    
    /** currently do nothing */    
    public void handleDeleteEvent(DomainConfig cfg) throws DomainException {
    }
}
