/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.Vector;
import java.net.InetAddress;
import java.net.UnknownHostException;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;

/**
   Class which contains Meta data for all types of attributes which is present in Validation Descriptor
   *  XML File
   *
   *  Sample
   *      <attribute name=<Name> type="address" />
   *      <attribute name=<Name> type="integer" range="low,high" />
   *      <attribute name=<Name> type="string"  max-length="length" />
    
   @author Srinivas Krishnan
   @version 2.0
*/

/* Class for attribute type address (IP Address) */

public class AttrAddress extends AttrType {
    
    public AttrAddress(String name, String type, boolean optional) {
        super(name,type, optional);
    }
    
    public void validate(Object o, ValidationContext valCtx) {
        super.validate(o, valCtx); // call to common validator first
        String address = null;
        if(o == null)
            return;
        if(o.equals("")) {
            valCtx.result.failed(valCtx.smh.getLocalString(getClass().getName() + ".invalidNullStrAddress",
                                                             "Attribute({0}=null) :  Null address not permitted", new Object[]{valCtx.attrName}));
            return;
        }
        address = (String)o;
        try {
            StaticTest.checkIPAddress(address);
        } catch(UnknownHostException u) {
            valCtx.result.failed(valCtx.smh.getLocalString(getClass().getName() + ".invalidAddress",
                                                             "Attribute({0}={1}) :  Invalid address syntax - {1}",
                                                             new Object[]{valCtx.attrName,address}));
        }
    }
    
}
