/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.TreeMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;



/**
 * Frame.java
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.3 $
 */

class Frame {
      // The top frames have a special parent - this one responds to
      // "lookup(s)" by merely looking in the environment and/or
      // returning the key as a variable.
    static Frame newFrame(){
        return new Frame(
                new Frame(){
                    String lookup(String s){
                    return (System.getProperty(s) != null
                            ? System.getProperty(s)
                            : "${"+s+"}");
                    }
                    public String toString(){
                        return "[]";
                    }
                }
                );
    }
    static Frame newFrame(Frame f){
        return new Frame(f);
    }
    String lookup(String s){
        return (map.get(s) != null ? (String) map.get(s) : parent.lookup(s));
    }
    
    Frame put(String key, String value){
        map.put(key, value);
        return this;
    }

    Frame inheritFrom(Frame f) throws IllegalArgumentException {
        if (contains(getAncestors(),f) || contains(f.getAncestors(),this)){
            throw new IllegalArgumentException("Inheriting from an ancestor is illegal - it causes loops!");
        }
        parent = f;
        return this;
    }

    private boolean contains(Set s, Frame f){
        for (Iterator it = s.iterator(); it.hasNext();){
            if (it.next() == f) {
                return true;
            }
        }
        return false;
    }

    public String toString(){
        StringBuffer sb = new StringBuffer("[");
        for (Iterator it = map.entrySet().iterator(); it.hasNext();){
            Map.Entry e = (Map.Entry) it.next();
            sb.append(e.getKey() + "->" + e.getValue());
            if (it.hasNext()){
                sb.append(", ");
            }
        }
        sb.append(" "+parent +"]");
        return sb.toString();
    }
    
        
    public boolean equals(Object o){
        return this == o || (o != null && o instanceof Frame && this.equals((Frame) o));
    }
      /*
       * The contract for equals and hashcode is:
       * FORALL a, b . a.equals(b) => a.hashCode() == b.hashCode()
       *
       * This will be true in this case because only when two frames
       * have equal maps (amongst other things) can they be
       * equal(), therefore the map hashCodes will be ==.
      */
    public int hashCode(){
        return map.hashCode();
    }
    
    private boolean equals(Frame o){
        return o != null
        && (this.map.equals(o.map)
            && ((this.parent == null && o.parent == null) ||
                (this.parent != null  && this.parent.equals(o.parent))));
    }


    
    private Frame(){}
    private Frame(Frame f){
        parent = f;
    }
    
    private Map map = new TreeMap();
    private Frame parent;
    
    private Set getAncestors(){
        if (parent == null){
            return new HashSet();
        } else {
            Set ancestors = parent.getAncestors();
            ancestors.add(this);
            return ancestors;
        }
            
    }
    
}

