/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.io.Writer;
import org.xml.sax.helpers.DefaultHandler;
import com.sun.enterprise.util.LocalStringManager;
import java.util.ArrayList;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.xml.sax.Attributes;
import java.util.logging.Logger;

class Localiser extends DefaultHandler
{
    private final LocalStringManager lsm;
    private final Writer out;
    private final Logger logger;
    private final String prefix;
    

    Localiser(final LocalStringManager lsm, final Writer out, final String prefix){
        this(lsm, out, null, prefix);
    }

    Localiser(final LocalStringManager lsm, final Writer out, final Logger logger){
        this(lsm, out, logger, null);
    }

    Localiser(final LocalStringManager lsm, final Writer out){
        this(lsm, out, null, null);
    }
    
    Localiser(final LocalStringManager lsm, final Writer out, final Logger logger, final String prefix){
        this.lsm = lsm;
        this.out = out;
        this.logger = logger;
        this.prefix = (prefix == null ? "" : prefix +".");
    }

    public void startElement(final String namespaceURI,
                         final String localName,
                         final String qName,
                         final Attributes atts)
        throws SAXException {
        if (localName.equals("location")){
            startLocation();
        } else if (localName.equals("message")){
            startMessage(atts);
        } else if (localName.equals("param")) {
            startParam(atts);
        }
    }
    public void characters(char[] ch,
                       int start,
                       int length)
        throws SAXException{
        if (null != textBuffer){
            textBuffer.append(ch, start, length);
        }
    }

    public void endElement(String namespaceURI,
                           String localName,
                           String qName)
        throws SAXException{
        if (localName.equals("location")){
            endLocation();
        } else if (localName.equals("message")){
            endMessage();
        } else if (localName.equals("param")) {
            endParam();
        }
    }

    private String message_id;
    private ArrayList params = new ArrayList(5);
    private StringBuffer textBuffer;

    private void startLocation(){
        textBuffer = new StringBuffer();
    }

    private void endLocation() throws SAXException {
        if (null != textBuffer && textBuffer.length() > 0){
            try {
                textBuffer.append(" ");
                out.write(textBuffer.toString());
            }
            catch (IOException e){
                throw new SAXException(e);
            }
        }
        textBuffer = null;
    }
    
    private void startMessage(final Attributes attr) throws SAXException {
        params.clear();
        final String id = attr.getValue("", "id");
        if (null == id || id.length() == 0){
            throw new SAXException("id attribute is either null or empty");
        }
        message_id = prefix + id;
    }

    private void startParam(final Attributes attr) {
        textBuffer = new StringBuffer();
    }
    
    private void endParam(){
        params.add(textBuffer.toString());
        textBuffer = null;
    }

    private void endMessage() throws SAXException {
        final String msg = lsm.getLocalString(null, message_id,
                           "Internal Error, message id  \""+message_id+ "\" not present in localisation file",
                           params.toArray());
        message_id = null;
        
        if (null != logger && msg.startsWith("Internal Error")){
            logger.severe(msg);
            return;
        }
        
        try {
            out.write(msg+"\n");
            out.flush();
        }
        catch (IOException e){
            throw new SAXException(e);
        }
        
            
    }
        
}
