/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.Map;
import java.util.HashMap;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.ElementProperty;

/**
 * helper class with convenience util methods
 * for property changes validation 
*/

/* Class for attribute type Integer */

public abstract class PropertyHelper {
    
    static final String ELEMENT_PROPERTY = "ElementProperty";
    static final String PROP_NAME_ATTRNAME = "name";
    static final String PROP_VALUE_ATTRNAME = "value";

    /***********************************************************    
     *
     * this method can be called from a custom validator
     * during validatePropertyChanges
    ************************************************************/
    static public Map getPropertiesMap(ConfigBean parent) {
        HashMap map = new HashMap();
        if(parent!=null)
        {
            ElementProperty[] props = 
                    (ElementProperty[])parent.getValues(ELEMENT_PROPERTY);
            if(props!=null)
            {
                for(int i=0; i<props.length; i++)
                {
                    map.put(props[i].getName(), props[i].getValue());
                }
            }
        }    
        return map;
    }
   
    /********************************************************
     *
     * returns true is named property will be changed as result of change event
     *
     ********************************************************/
    static public boolean isPropertyChanged(ValidationContext propValCtx, String name) {
        ElementProperty prop = (ElementProperty)propValCtx.getTargetBean();
        if(!prop.getName().equals(name))
        {
            //check if name of property changing to checked one
            if(!propValCtx.isUPDATE() ||
               !PROP_NAME_ATTRNAME.equals(propValCtx.name) ||
               !name.equals(propValCtx.value))
            {
                //not related changes
                return false;
            }
        }
        
        // first get current properties as map
        Map map = getPropertiesMap(propValCtx.getParentBean());
        // save "old" value for tested property
        String oldValue = (String)map.get(name);
        // "apply" change over existing props
        addChangesToPropertiesMap(propValCtx, map);
        // get "new" value for tested property
        String newValue = (String)map.get(name);
        // now - compare
        if((oldValue==null && newValue==null) ||
           (oldValue!=null && oldValue.equals(newValue)) )
        {
            //we are trying to set prop to already existing value
            return false;
        }
        return true;
    }
    
    /********************************************************
     * returns map of element properties if changes would be accepted
     *
     *********************************************************/
    static public Map getFuturePropertiesMap(ValidationContext propValCtx) {
        Map map = getPropertiesMap(propValCtx.getParentBean());
        return addChangesToPropertiesMap(propValCtx, map);
    }

    /********************************************************
     *********************************************************/
    static private Map addChangesToPropertiesMap(ValidationContext propValCtx, Map map) {
        if(propValCtx.isADD() || propValCtx.isSET())
        {
            ElementProperty prop = (ElementProperty)propValCtx.getTargetBean();
            map.put(prop.getName(), prop.getValue());
        }
        else if(propValCtx.isUPDATE())
        {
            ElementProperty prop = (ElementProperty)propValCtx.getTargetBean();
            if(PROP_NAME_ATTRNAME.equals(propValCtx.name))
            {
                // when name of property is changing
                map.remove(prop.getName());
                map.put(propValCtx.value, prop.getValue());
            }
            else
            {
                // when value of property is changing
                map.put(prop.getName(), propValCtx.value);
            }
        }
        return map;
    }
    
}
