/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;
import java.util.logging.Level;

import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.config.serverbeans.ProviderConfig;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;

public class ProviderConfigTest extends GenericValidator {
    
    private static final char [] illegalChars = {'*', ',', ':'};

    public ProviderConfigTest (ValidationDescriptor desc) {
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {

        Result result = super.validate(cce);
        try {
            if (cce.getChoice().equals(StaticTest.DELETE)){
                if (isReferencedByParent(cce)){
                    result.failed(
                        smh.getLocalString(
                            getClass().getName() + ".cannotDeleteReferencedProviderConfig",
                            "provider config (provider-id={0}) can not be removed. It is referenced by its parent message-security-config",
                            new Object[]{getProviderConfig(cce).getProviderId()}));
                }
            }
        }
        catch (Exception e){
            _logger.log(Level.FINE, "domainxmlverifier.exception", e);
        }
            
        return result;
    }

    private final boolean isReferencedByParent(final ConfigContextEvent cce) throws ConfigException {
        final ProviderConfig pc = getProviderConfig(cce);
        final MessageSecurityConfig msc = (MessageSecurityConfig) pc.parent().parent();
        return msc.getDefaultProvider() != null && msc.getDefaultProvider().equals(pc.getProviderId());
    }

    private ProviderConfig getProviderConfig(final ConfigContextEvent cce) throws ConfigException {
        return (ProviderConfig) cce.getValidationTarget();
    }
    
}
