/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.agent;

import com.sun.enterprise.webservice.monitoring.GlobalMessageListener;
import com.sun.enterprise.webservice.monitoring.AuthenticationListener;
import com.sun.enterprise.webservice.monitoring.WebServiceEngine;
import com.sun.enterprise.webservice.monitoring.WebServiceEngineFactory;

/**
 * This class interacts with JAX RPC Monitoring SPI and registers Global
 * Listener to get callbacks. 
 */
public class ListenerManager {

    /**
     * Registers the Global Listener.
     */
    public void register() {
        WebServiceEngine wsEng =
        WebServiceEngineFactory.getInstance().getEngine();

        GlobalMessageListener gml = new GlobalMessageListenerImpl();
        AuthenticationListener al = new AuthenticationListenerImpl();
        wsEng.setGlobalMessageListener(gml);
        wsEng.addAuthListener(al);

        if (wsEng.getGlobalMessageListener() == null) {
            throw new RuntimeException("Message Listener could not be set");
        }
    }

    public static synchronized ListenerManager getInstance() {
        if ( lm == null) {
            lm = new ListenerManager();
        }
        return lm;
    }

    private static ListenerManager lm = null;

    private ListenerManager() {}
}
