/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.config.spi;

import java.util.List;

/**
 * This is the mechanism to access web service management configuration. 
 */
public interface ConfigProvider {

    /**
     * Returns the unique identifier for this RepositoryProvider object.
     *
     * @return fully qualified class name of this RepositoryProvider
     */
    public String getProviderID();

    /**
     * Returns the list of Web Service Endpoint config in this application 
     *
     * @param appName   Name of the application
     *
     * @return the array of WebServiceConfig
     */
    public WebServiceConfig[] getWebserviceConfigs(String appId);

    /**
     * Returns the list of Web Service Endpoint config in this application 
     *
     * @param appName   Name of the application
     *
     * @return the WebServiceConfig
     */
    public WebServiceConfig getWebServiceConfig(String appId, String modId,
        boolean isStandalone, String name);

    /**
     * Returns the list of Web Service Endpoint config in this application 
     *
     * @param fqn   Fully Qualified name of the endpoint
     *
     * @return the WebServiceConfig
     */
    public WebServiceConfig getWebServiceConfig(String fqn);

    /**
     * Returns a list of application or stand alone module ids 
     * currently configured for web service management.
     *
     * @return  managed web service application ids
     */
    public List getManagedWebserviceApplicationIds();
}
