/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.config.spi;

/**
 * This represents management configuration for a web service end point. 
 */
public interface WebServiceConfig {

    /**
     * Returns the name of the web service endpoint
     *
     * @return the name of the web service endpoint
     */
    public String getName();

    /**
     * Returns the name of the web service endpoint name (relative i.e. does not
     * include module id in the name.
     *
     * @return the relative name of the web service endpoint
     */
    public String getEndpointName();

    /**
     * Returns the monitoring level OFF, LOW or HIGH 
     *
     * @return the monitoring level OFF, LOW or HIGH 
     */
    public String getMonitoringLevel();

    /**
     * Returns the max history size (size of stored monitoring stats)
     *
     * @return the max history size (size of stored monitoring stats)
     */
    public int getMaxHistorySize();

    /**
     * Returns true, if this web service endpoint JBI enabled
     *
     * @return true, if this web service endpoint JBI enabled
     */
    public boolean getJbiEnabled();
    
    /**
     * Returns the transformation rules defined for this endpoint
     *
     * @return the transformation rules defined for this endpoint
     */
    public TransformationRule[] getTransformationRule();

    /**
     * Returns the transformation rules defined for this endpoint
     * during request phase
     *
     * @return the transformation rules defined for this endpoint
     */
    public TransformationRule[] getRequestTransformationRule();

    /**
     * Returns the transformation rules defined for this endpoint
     * during response phase
     *
     * @return the transformation rules defined for this endpoint
     */
    public TransformationRule[] getResponseTransformationRule();

    /**
     * Returns the registries where the web service end point artifacts are
     * published.
     *
     * @return the registries where the web service end point artifacts are
     * published.
     */
    public RegistryLocation[] getRegistryLocation();
}
