/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.msg;

import com.sun.enterprise.admin.wsmgmt.WSMgmtException;

/**
 * An exception that provides information on web service management error.
 */
public class MessageTraceException extends WSMgmtException {

    /**
     * Constructs a web service management exception with the specified message
     * and cause.
     *
     * @param   msg    the detail message for this exception
     * @param   cause  the cause of this error
     */
    public MessageTraceException(String msg, Throwable cause) {
        super(msg, cause);
    }

    /**
     * Constructs a web service management exception with the cause.
     *
     * @param   cause  the cause of this error
     */
    public MessageTraceException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a web service management exception with the specified message.
     *
     * @param   msg    the detail message for this exception
     */
    public MessageTraceException(String msg) {
        super(msg);
    }

    /**
     * Constructs a web service management exception.
     */
    public MessageTraceException() {
        super();
    }
}
